#include "sgetopt.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"

char const *PROG = "fdmove" ;
#define USAGE "fdmove [ -c ] to from prog..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  int to, from ;
  unsigned char flagcopy = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "c")) != opteof)
      switch (opt)
      {
        case 'c' : flagcopy = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  if ((argc < 3)
   || !uint0_scan(argv[0], &to)
   || !uint0_scan(argv[1], &from))
    strerr_dieusage(100, USAGE) ;
  if ((flagcopy ? fd_copy(to, from) : fd_move(to, from)) == -1)
    strerr_diefu4sys(111, "move fd ", argv[1], " to fd ", argv[0]) ;
  pathexec_run(argv[2], argv+2, envp) ;
  strerr_dieexec(111, argv[2]) ;
}
