#include <unistd.h>
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"

char const *PROG  = "fdreserve" ;
#define USAGE "fdreserve n prog..."

#define MAXFDS 1024

static void doit (unsigned int i, int fd)
{
  char fmti[8] = "FD\0\0\0\0\0" ;
  char fmtf[FMT_ULONG] ;
  uint_fmt(fmti+2, i) ;
  fmtf[uint_fmt(fmtf, (unsigned int)fd)] = 0 ;
  if (!pathexec_env(fmti, fmtf))
    strerr_diefu2sys(111, "set ", fmti) ;
}

int main (int argc, char const *const *argv)
{
  int fd[MAXFDS>>1][2] ;
  unsigned int n ;
  unsigned int i = 0 ;
  if ((argc < 3) || !uint0_scan(argv[1], &n))
    strerr_dieusage(100, USAGE) ;
  if (n > MAXFDS) strerr_dief1x(100, "too many requested fds") ;

  for (; i < (n>>1)+(n&1) ; i++)
    if (pipe(fd[i]) == -1)
      strerr_diefu1sys(111, "reserve fds") ;
  for (i = 0 ; i < (n>>1)+(n&1) ; i++)
  {
    fd_close(fd[i][0]) ;
    fd_close(fd[i][1]) ;
  }
  for (i = 0 ; i < (n>>1) ; i++)
  {
    doit(i<<1, fd[i][0]) ;
    doit((i<<1)|1, fd[i][1]) ;
  }
  if (n&1) doit(n-1, fd[n>>1][0]) ;
  pathexec(argv+2) ;
  strerr_dieexec(111, argv[1]) ;
}
