#include <unistd.h>
#include "sgetopt.h"
#include "bytestr.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "env.h"
#include "envalloc.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "for" ;
#define USAGE "for [ -p ] key ~values... ; ~command... ; [ remainder... ]"

int main (int argc, char const **argv, char const *const *envp)
{
  int wstat ;
  int argc1, argc2 ;
  char const *key ;
  unsigned char flagwait = 1 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "p")) != opteof)
      switch (opt)
      {
        case 'p' : flagwait = 0 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  if (argc < 2) strerr_dieusage(100, USAGE) ;
  key = argv[0] ;
  argv++ ; argc-- ;
  argc1 = el_semicolon(argv) ;
  if (argc1 >= argc) strerr_dief1x(100, "unterminated values block") ;
  if (argc1 + 1 == argc) return 0 ;
  argc2 = el_semicolon(argv + argc1 + 1) ;
  if (argc1 + argc2 + 1 >= argc) strerr_dief1x(100, "unterminated command block") ;
  if (argc1 && argc2)
  {
    stralloc src = GEN_ALLOC_ZERO ;
    elsubst blah ;
    unsigned int i = 0 ;
    argv[argc1 + argc2 + 1] = 0 ;
    if (!env_string(&src, argv + argc1 + 1, argc2))
      strerr_diefu1sys(111, "parse") ;
    blah.var = key ;
    blah.n = 1 ;
    for (; i < (unsigned int)argc1 ; i++)
    {
      int pid = fork() ;
      switch (pid)
      {
        case -1: strerr_diefu1sys(111, "fork") ;
        case 0:
        {
          stralloc dst = GEN_ALLOC_ZERO ;
          envalloc v = GEN_ALLOC_ZERO ;
          int r ;
          blah.value = argv[i] ;
          r = el_substitute(&dst, src.s, src.len, &blah, 1) ;
          if (r < 0)
            strerr_diewu4sys(111, "replace ", key, " with ", argv[i]) ;
          if (!envalloc_make(&v, (unsigned int)argc2, dst.s, dst.len)
           || !envalloc_0(&v))
            strerr_diewu1sys(111, "make argv") ;
          stralloc_free(&src) ;
          pathexec_run(v.s[0], v.s, envp) ;
          strerr_diewu2sys(111, "spawn ", v.s[0]) ;
        }
      }
      if (flagwait && (wait_pid(&wstat, pid) == -1))
        strerr_diefu2sys(111, "wait for ", argv[argc1+1]) ;
    }
    stralloc_free(&src) ;
  }
  pathexec0_run(argv + argc1 + argc2 + 2, envp) ;
  strerr_dieexec(111, argv[argc1 + argc2 + 2]) ;
}
