#include <unistd.h>
#include <errno.h>
#include "sgetopt.h"
#include "bytestr.h"
#include "buffer.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "env.h"
#include "envalloc.h"
#include "djbunix.h"
#include "skamisc.h"
#include "netstring.h"
#include "execline.h"

char const *PROG = "forbacktick" ;
#define USAGE "forbacktick [ -p ] [ -n ] [ -C | -c ] [ -d delim ] key ~backtickcmd... ; ~command... ; [ remainder... ]"

int main (int argc, char const **argv, char const *const *envp)
{
  char const *delim = " \n\r\t" ;
  int argc1, argc2 ;
  elsubst blah ;
  unsigned char crunch = 0, flagpar = 0, chomp = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "pnCcd:")) != opteof)
      switch (opt)
      {
        case 'p' : flagpar = 1 ; break ;
        case 'n' : chomp = 1 ; break ;
        case 'C' : crunch = 1 ; break ;
        case 'c' : crunch = 0 ; break ;
        case 'd' : delim = optarg ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  if (argc < 2) strerr_dieusage(100, USAGE) ;
  blah.var = argv[0] ;
  blah.n = 1 ;
  argv++ ; argc-- ;
  argc1 = el_semicolon(argv) ;
  if (argc1 >= argc) strerr_dief1x(100, "unterminated first block") ;
  if (argc1 + 1 == argc) strerr_dief1x(100, "second block required") ;
  argc2 = el_semicolon(argv + argc1 + 1) ;
  if (argc1 + argc2 + 1 >= argc) strerr_dief1x(100, "unterminated second block") ;
  argv[argc1 + argc2 + 1] = 0 ;
  if (argc1 && argc2)
  {
    int pidw ;
    int wstat ;
    int fd[2] ;

    if (pipe(fd) == -1) strerr_diefu1sys(111, "create pipe") ;
    pidw = fork() ;
    switch (pidw)
    {
      case -1: strerr_diefu1sys(111, "fork") ;
      case 0:
        argv[argc1] = 0 ;
        fd_close(fd[0]) ;
        if (fd_move(1, fd[1]) == -1)
          strerr_diewu1sys(111, "move writer fd") ;
        pathexec_run(argv[0], argv, envp) ;
        strerr_diewu2sys(111, "spawn ", argv[0]) ;
    }
    fd_close(fd[1]) ;
    {
      char buf[BUFFER_INSIZE] ;
      buffer b = BUFFER_INIT(&buffer_unixread, fd[0], buf, BUFFER_INSIZE) ;
      stralloc src = GEN_ALLOC_ZERO ;
      stralloc val = GEN_ALLOC_ZERO ;
      unsigned int delimlen = str_len(delim) ;

      if (!env_string(&src, argv + argc1 + 1, argc2)) goto err ;
      for (;;)
      {
        int pid ;
        int wstat ;

        val.len = 0 ;
        if (delimlen)
        {
          register int r = skagetlnsep(&b, &val, delim, delimlen) ;
          if (!r) break ;
          if ((r == -1) && (errno != EPIPE))
            strerr_diefu1sys(111, "read command's result") ;
          if ((r == -1) && chomp) break ;
          if (r > 0) val.len-- ;
          if (!val.len && crunch) continue ;
        }
        else
        {
          unsigned int unread = 0 ;
          register int r = netstring_get(&b, &val, &unread) ;
          if (!r) break ;
          if (r == -1)
            strerr_diefu1sys(111, "read a netstring") ;
        }
        if (!stralloc_0(&val)) goto err ;
        blah.value = val.s ;
        pid = fork() ;
        switch (pid)
        {
          case -1: strerr_diefu1sys(111, "fork") ;
          case 0:
          {
            stralloc dst = GEN_ALLOC_ZERO ;
            envalloc v = GEN_ALLOC_ZERO ;
            int nc = el_substitute(&dst, src.s, src.len, &blah, 1) ;
            if (nc < 0)
              strerr_diewu4sys(111, "replace ", blah.var, " with ", blah.value) ;
            stralloc_free(&val) ;
            stralloc_free(&src) ;
           /* assert(nc == argc2) ; */
            if (!envalloc_make(&v, (unsigned int)nc, dst.s, dst.len)
             || !envalloc_0(&v))
              strerr_diewu1sys(111, "make argv") ;
            pathexec_run(v.s[0], v.s, envp) ;
            strerr_diewu2sys(111, "spawn ", v.s[0]) ;
          }
        }
        if (!flagpar && (wait_pid(&wstat, pid) == -1))
          strerr_diefu2sys(111, "wait for ", argv[argc1+1]) ;
      }
      stralloc_free(&val) ;
      stralloc_free(&src) ;
    }
    fd_close(fd[0]) ;
    if (wait_pid(&wstat, pidw) == -1)
      strerr_diefu2sys(111, "wait for ", argv[0]) ;
  }
  pathexec0_run(argv + argc1 + argc2 + 2, envp) ;
  strerr_dieexec(111, argv[argc1 + argc2 + 2]) ;

err:
  strerr_diefu1sys(111, "perform loop") ;
}
