#include <sys/types.h>
#include <unistd.h>
#include "bytestr.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"

char const *PROG = "getpid" ;
#define USAGE "getpid variable prog..."

int main (int argc, char const *const *argv)
{
  char fmt[FMT_ULONG] ;
  if (argc < 3) strerr_dieusage(100, USAGE) ;
  if (argv[1][str_chr(argv[1], '=')])
    strerr_dief2x(100, "invalid variable name: ", argv[1]) ;
  fmt[uint_fmt(fmt, getpid())] = 0 ;
  if (!pathexec_env(argv[1], fmt))
    strerr_diefu4sys(111, "set ", argv[1], " to ", fmt) ;
  pathexec(argv+2) ;
  strerr_dieexec(111, argv[2]) ;
}
