#include <unistd.h>
#include "sgetopt.h"
#include "bytestr.h"
#include "fmtscan.h"
#include "allreadwrite.h"
#include "strerr2.h"
#include "djbunix.h"

char const *PROG = "heredoc" ;
#define USAGE "heredoc [ -d ] fd string command..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  char fmt[FMT_ULONG] ;
  unsigned char df = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "d")) != opteof)
      switch (opt)
      {
        case 'd' : df = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  {
    int fd[2] ;
    int fdr ;
    int pid ;
    if ((argc < 2) || !uint0_scan(argv[0], &fdr)) strerr_dieusage(100, USAGE) ;
    if (pipe(fd) == -1)
      strerr_diefu1sys(111, "create pipe") ;
    pid = df ? doublefork() : fork() ;
    switch (pid)
    {
      case -1: strerr_diefu2sys(111, df ? "double" : "", "fork") ;
      case 0:
      {
        unsigned int len = str_len(argv[1]) ;
        return (allwrite(fd[1], argv[1], len) < len) ? 111 : 0 ;
      }
    }
    fd_close(fd[1]) ;
    fmt[uint_fmt(fmt, pid)] = 0 ;
    if (fd_move(fdr, fd[0]) == -1)
      strerr_diefu2sys(111, "read on fd ", argv[0]) ;
  }
  pathexec_run(argv[2], argv+2, envp) ;
  strerr_dieexec(111, argv[2]) ;
}
