#include <unistd.h>
#include "sgetopt.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "if" ;
#define USAGE "if [ -n ] [ -t ] ~command... ; [ remainder... ]"

int main (int argc, char const **argv, char const *const *envp)
{
  int argc1, wstat ;
  int pid ;
  unsigned char not = 0 ;
  int e = 1 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "nt")) != opteof)
      switch (opt)
      {
        case 'n' : not = 1 ; break ;
        case 't' : e = 0 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  argc1 = el_semicolon(argv) ;
  if (argc1 >= argc) strerr_dief1x(100, "unterminated block") ;
  pid = fork() ;
  switch (pid)
  {
    case -1: strerr_diefu1sys(111, "fork") ;
    case 0:
      argv[argc1] = 0 ;
      pathexec0_run(argv, envp) ;
      strerr_diefu2sys(111, "spawn ", argv[0]) ;
  }
  if (wait_pid(&wstat, pid) == -1)
    strerr_diefu1sys(111, "wait") ;
  if (wait_status(wstat) ? !not : not) return e ;
  pathexec0_run(argv+argc1+1, envp) ;
  strerr_dieexec(111, argv[argc1+1]) ;
}
