#include <unistd.h>
#include "sgetopt.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "ifthenelse" ;
#define USAGE "ifthenelse [ -s ] ~command-if... ; ~command-then... ; ~command-else... ; [ remainder... ]"

int main (int argc, char const **argv, char const *const *envp)
{
  int argc1, argc2, argc3, wstat ;
  unsigned char magicscope = 0 ;
  int pid ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "s")) != opteof)
      switch (opt)
      {
        case 's' : magicscope = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  argc1 = el_semicolon(argv) ;
  if (argc1 >= argc) strerr_dief1x(100, "unterminated if block") ;
  if (argc1 + 1 == argc) strerr_dief1x(100, "then block required") ;
  argc2 = el_semicolon(argv + argc1 + 1) ;
  if (argc1 + argc2 + 1 >= argc) strerr_dief1x(100, "unterminated then block") ;
  argc3 = el_semicolon(argv + argc1 + argc2 + 2) ;
  if (argc1 + argc2 + argc3 + 2 >= argc)
    strerr_dief1x(100, "unterminated else block") ;

  pid = fork() ;
  switch (pid)
  {
    case -1: strerr_diefu1sys(111, "fork") ;
    case 0:
      argv[argc1] = 0 ;
      pathexec0_run(argv, envp) ;
      strerr_diewu2sys(111, "spawn ", argv[0]) ;
  }
  if (wait_pid(&wstat, pid) == -1)
    strerr_diefu2sys(111, "wait for ", argv[0]) ;
  argv += argc1 + 1 ;
  {
    char const *const *remainder = argv + argc2 + argc3 + 2 ;
    if (wait_status(wstat))
    {
      argv += argc2 + 1 ;
      argc2 = argc3 ;
    }
    if (magicscope)
    {
      register unsigned int i = 0 ;
      for (; remainder[i] ; i++) argv[argc2+i] = remainder[i] ;
      argv[argc2+i] = 0 ;
      pathexec0_run(argv, envp) ;
      strerr_dieexec(111, argv[0]) ;
    }
    else
    {
      argv[argc2] = 0 ;
      el_execsequence(argv, remainder) ;
    }
  }
}
