#include <unistd.h>
#include "sgetopt.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "loopwhile" ;
#define USAGE "loopwhile [ -n ] ~prog... ; [ remainder... ]"

int main (int argc, char const **argv, char const *const *envp)
{
  int argc1 ;
  unsigned char cont = 1, not = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "n")) != opteof)
      switch (opt)
      {
        case 'n' : not = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  argc1 = el_semicolon(argv) ;
  if (!argc1) strerr_dief1x(100, "empty block not allowed") ;
  if (argc1 >= argc) strerr_dief1x(100, "unterminated block") ;
  argv[argc1] = 0 ;
  while (cont)
  {
    int wstat ;
    int pid = fork() ;
    switch (pid)
    {
      case -1: strerr_diefu1sys(111, "fork") ;
      case 0:
        pathexec_run(argv[0], argv, envp) ;
        strerr_diewu2sys(111, "spawn ", argv[0]) ;
    }
    if (wait_pid(&wstat, pid) == -1)
      strerr_diefu1sys(111, "wait") ;
    cont = wait_status(wstat) ? not : !not ;
  }
  pathexec0_run(argv + argc1 + 1, envp) ;
  strerr_dieexec(111, argv[argc1 + 1]) ;
}
