#include "bytestr.h"
#include "fmtscan.h"
#include "sgetopt.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "env.h"
#include "envalloc.h"
#include "uintalloc.h"
#include "djbunix.h"
#include "execline.h"
#include "exls1.h"
#include "exlp.h"

char const *PROG = "multisubstitute" ;
#define USAGE "see http://www.skarnet.org/software/execline/multisubstitute.html"

static char const *commands[6] = { "define", "importas", "import", "backtick", "elglob", 0 } ;
static exls1_t_ref functions[6] = { &exls1_define, &exls1_importas, &exls1_import, &exls1_backtick, &exls1_elglob, 0 } ;

static void die (void)
{
  strerr_diefu1sys(111, "perform substitution") ;
}

int main (int argc, char const **argv, char const *const *envp)
{
  substalloc big = GEN_ALLOC_ZERO ;
  stralloc vars = GEN_ALLOC_ZERO ;
  exls1info si = EXLS1INFO_ZERO ;
  uintalloc offsets = GEN_ALLOC_ZERO ; /* realloc messes up pointers */
  int argc1 ;
  unsigned int nmin = 0 ;
  unsigned char positionals = 0 ;

 /* Read options and a block */
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "P:")) != opteof)
      switch (opt)
      {
        case 'P' : positionals = 1 ; if (uint0_scan(optarg, &nmin)) break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  if (!argc) strerr_dieusage(100, USAGE) ;
  argc1 = el_semicolon(argv) ;
  if (argc1 >= argc) strerr_dief1x(100, "unterminated block") ;
  if (argc1 + 1 == argc) strerr_dieusage(100, USAGE) ;

 /* Parse args and update the substalloc */
  while (argc1)
  {
    int n ;
    unsigned int i = 0 ;
    for ( ; commands[i] ; i++) if (!str_diff(*argv, commands[i])) break ;
    if (!commands[i])
      strerr_dief2x(100, "syntax error: unrecognized directive ", *argv) ;
    if (!uintalloc_catb(&offsets, &vars.len, 1)
     || !uintalloc_catb(&offsets, &si.value.len, 1)) die() ;
    n = (*(functions[i]))(argc1, argv, envp, &si) ;
    switch (n)
    {
      case -3 :
        strerr_dief2x(100, "syntax error at directive ", commands[i]) ;
      case -2 :
      case -1 :
        strerr_diefu2sys(111, "perform directive ", commands[i]) ;
    }
    argv += n ; argc1 -= n ; argc -= n ;
    if (!*si.var) strerr_dief1x(100, "empty key not allowed") ;
    if (el_vardupl(si.var, vars.s, vars.len))
      strerr_dief3x(100, "key ", si.var, " appears more than once") ;
    if (!stralloc_cats(&vars, si.var) || !stralloc_0(&vars)) die() ;
    if (!substalloc_readyplus(&big, 1)) die() ;
    big.s[big.len++].n = si.n ;
  }

 /* Update the substalloc with positionals */
  if (positionals)
  {
    unsigned int i = 0 ;
    unsigned int n = exlp(nmin, envp, &vars, &si.value, &offsets) ;
    unsigned int ntot = n > nmin ? n : nmin ;
    if (!substalloc_readyplus(&big, ntot+3)) die() ;
    for ( ; i < ntot+2 ; i++) big.s[big.len++].n = 1 ;
    big.s[big.len++].n = n ;    
  }

 /* No more reallocs - set pointers */
  el_updatesubsts(big.s, big.len, vars.s, si.value.s, offsets.s) ;
  uintalloc_free(&offsets) ;

 /* Perform the substitution and exec */
  {
    stralloc src = GEN_ALLOC_ZERO ;
    stralloc dst = GEN_ALLOC_ZERO ;
    envalloc v = GEN_ALLOC_ZERO ;
    int nc ;
    if (!env_string(&src, argv+1, argc-1)) die() ;
    nc = el_substitute(&dst, src.s, src.len, big.s, big.len) ;
    stralloc_free(&src) ;
    substalloc_free(&big) ;
    stralloc_free(&vars) ;
    stralloc_free(&si.value) ;
    if ((nc < 0)
     || !envalloc_make(&v, (unsigned int)nc, dst.s, dst.len)
     || !envalloc_0(&v)) die() ;
    pathexec0_run(v.s, envp) ;
    strerr_dieexec(111, v.s[0]) ;
  }
}
