#include <unistd.h>
#include "sgetopt.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "pipeline" ;
#define USAGE "pipeline [ -d ] [ -r | -w ] ~command... ; command..."

int main (int argc, char const **argv)
{
  unsigned char df = 0 ;
  int w = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "drw")) != opteof)
      switch (opt)
      {
        case 'd' : df = 1 ; break ;
        case 'r' : w = 0 ; break ;
        case 'w' : w = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  {
    char fmt[FMT_ULONG] ;
    int fd[2] ;
    int pid ;
    int argc1 = el_semicolon(argv) ;
    if (argc1 >= argc) strerr_dief1x(100, "unterminated block") ;
    if (argc1 + 1 == argc) df = 0 ;
    if (pipe(fd) == -1)
      strerr_diefu1sys(111, "create pipe") ;
    pid = df ? doublefork() : fork() ;
    switch (pid)
    {
      case -1: strerr_diefu2sys(111, df ? "double" : "", "fork") ;
      case 0:
        fd_close(fd[w]) ;
        if (fd_move(1-w, fd[1-w]) == -1)
          strerr_diewu1sys(111, "move child fd") ;
        argv[argc1] = 0 ;
        pathexec0(argv) ;
        strerr_diewu2sys(111, "spawn ", argv[0]) ;
    }
    fmt[uint_fmt(fmt, pid)] = 0 ;
    fd_close(fd[1-w]) ;
    if (fd_move(w, fd[w]) == -1)
      strerr_diefu1sys(111, "move parent fd") ;
    if (!pathexec_env("LASTPID", fmt))
      strerr_diefu1sys(111, "update environment") ;
    pathexec0(argv + argc1 + 1) ;
    strerr_dieexec(111, argv[argc1 + 1]) ;
  }
}
