#include <fcntl.h>
#include <errno.h>
#include "sgetopt.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"

char const *PROG = "redirfd" ;
#define USAGE "redirfd -[r|w|u|a|c|x] [ -n ] [ -b ] fd file prog..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  int fd, fd2 ;
  unsigned int flags = 0 ;
  unsigned char changemode = 0 ;
  {
    int what = -1 ;
    register int opt ;
    while ((opt = subgetopt(argc, argv, "rwuacxnb")) != opteof)
      switch (opt)
      {
        case 'r' : what = O_RDONLY ; flags &= ~(O_APPEND|O_CREAT|O_TRUNC|O_EXCL) ; break ;
        case 'w' : what = O_WRONLY ; flags |= O_CREAT|O_TRUNC ; flags &= ~(O_APPEND|O_EXCL) ; break ;
        case 'u' : what = O_RDWR ; flags &= ~(O_APPEND|O_CREAT|O_TRUNC|O_EXCL) ; break ;
        case 'a' : what = O_WRONLY ; flags |= O_CREAT|O_APPEND ; flags &= ~(O_TRUNC|O_EXCL) ; break ;
        case 'c' : what = O_WRONLY ; flags |= O_APPEND ; flags &= ~(O_CREAT|O_TRUNC|O_EXCL) ; break ;
        case 'x' : what = O_WRONLY ; flags |= O_CREAT|O_EXCL ; flags &= ~(O_APPEND|O_TRUNC) ; break ;
        case 'n' : flags |= O_NONBLOCK ; break ;
        case 'b' : changemode = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
    if ((argc < 3) || !uint0_scan(argv[0], &fd) || (what == -1))
      strerr_dieusage(100, USAGE) ;
    flags |= what ;
  }
  fd2 = open3(argv[1], flags, 0666) ;
  if ((fd2 == -1) && (flags & O_WRONLY) && (errno == ENXIO))
  {
    int fdr = open_read(argv[1]) ;
    if (fdr == -1) strerr_diefu2sys(111, "open ", argv[1]) ;
    fd2 = open3(argv[1], flags, 0666) ;
    fd_close(fdr) ;
  }
  if (fd2 == -1) strerr_diefu2sys(111, "open ", argv[1]) ;
  if (fd_move(fd, fd2) == -1)
  {
    char fmt[FMT_ULONG] ;
    fmt[uint_fmt(fmt, fd2)] = 0 ;
    strerr_diefu4sys(111, "move fd ", fmt, " to fd ", argv[0]) ;
  }
  if (changemode)
  {
    if (flags & O_NONBLOCK) ndelay_off(fd) ; else ndelay_on(fd) ;
  }
  pathexec_run(argv[2], argv+2, envp) ;
  strerr_dieexec(111, argv[2]) ;
}
