#include "sgetopt.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "gen_alloc.h"
#include "stralloc.h"
#include "env.h"
#include "envalloc.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "runblock" ;
#define USAGE "runblock [ -P ] [ -n argshift ] [ -r ] n"

int main (int argc, char const *const *argv, char const *const *envp)
{
  envalloc v = GEN_ALLOC_ZERO ;
  unsigned int n, sharp ;
  unsigned int m = 0 ;
  unsigned int strict = el_getstrict() ;
  unsigned char flagnopop = 0, flagr = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "Prn:")) != opteof)
      switch (opt)
      {
        case 'P' : flagnopop = 1 ; break ;
        case 'r' : flagr = 1 ; break ;
        case 'n' : if (uint0_scan(optarg, &m)) break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  if (argc != 1) strerr_dieusage(100, USAGE) ;
  if (!uint0_scan(argv[0], &n) || !n) strerr_dieusage(100, USAGE) ;

  {
    char const *x = env_get2(envp, "#") ;
    if (!x) strerr_dienotset(100, "#") ;
    if (!uint0_scan(x, &sharp)) strerr_dieinvalid(100, "#") ;
  }

 /* Skip n-1 blocks (n if flagr) */
  {
    register unsigned int i = 1 ;
    for (; i < n + flagr ; i++)
    {
      unsigned int base = m ;
      for (;;)
      {
        char const *x ;
        char fmt[FMT_ULONG] ;
        if (++m > sharp)
          strerr_dief1x(100, "too few arguments") ;
        fmt[uint_fmt(fmt, m)] = 0 ;
        x = env_get2(envp, fmt) ;
        if (!x) strerr_dienotset(100, fmt) ;
        if ((x[0] == ';') && !x[1]) break ;
        if ((x[0] != '~') && strict)
        {
          char fmtb[FMT_ULONG] ;
          char fmti[FMT_ULONG] ;
          fmti[uint_fmt(fmti, i)] = 0 ;
          fmtb[uint_fmt(fmtb, m - base)] = 0 ;
          if (strict == 1)
            strerr_warnw6x("unquoted positional ", x, " at block ", fmti, " position ", fmtb) ;
          else
            strerr_dief6x(100, "unquoted positional ", x, " at block ", fmti, " position ", fmtb) ;
        }
      }
    }
  }

  if (flagr)  /* put remainder envvars into v */
  {
    if (++m == sharp) return 0 ;
    if (!envalloc_ready(&v, sharp - m + 2))
      strerr_diefu1sys(111, "make envalloc") ;
    for (; m <= sharp ; m++)
    {
      char const *x ;
      char fmt[FMT_ULONG] ;
      fmt[uint_fmt(fmt, m)] = 0 ;
      x = env_get2(envp, fmt) ;
      if (!x) strerr_dienotset(100, fmt) ;
      envalloc_catb(&v, &x, 1) ;
    }
  }
  else  /* put envvars from nth block into v */
  {
    unsigned int base = m ;
    for (;;)
    {
      char const *x ;
      char fmt[FMT_ULONG] ;
      if (++m > sharp)
        strerr_dief1x(100, "too few arguments") ;
      fmt[uint_fmt(fmt, m)] = 0 ;
      x = env_get2(envp, fmt) ;
      if (!x) strerr_dienotset(100, fmt) ;
      if ((x[0] == ';') && !x[1]) break ;
      if (x[0] != '~')
      {
        if (strict)
        {
          char fmtb[FMT_ULONG] ;
          char fmtn[FMT_ULONG] ;
          fmtn[uint_fmt(fmtn, n)] = 0 ;
          fmtb[uint_fmt(fmtb, m - base)] = 0 ;
          if (strict == 1)
            strerr_warnw6x("unquoted positional ", x, " at block ", fmtn, " position ", fmtb) ;
          else
            strerr_dief6x(100, "unquoted positional ", x, " at block ", fmtn, " position ", fmtb) ;
        }
      }
      else x++ ;
      if (!envalloc_catb(&v, &x, 1))
        strerr_diefu1sys(111, "make envalloc") ;
    }
  }

  if (!envalloc_0(&v))
    strerr_diefu1sys(111, "make envalloc") ;

  if (flagnopop)  /* exec now */
    pathexec_run(v.s[0], v.s, envp) ;
  else  /* popenv, then exec */
  {
    char const *list[11] = { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "#" } ;
    stralloc sa = GEN_ALLOC_ZERO ;
    envalloc w = GEN_ALLOC_ZERO ;
    unsigned int envlen = env_len(envp) ;
    int popped = el_popenv(&sa, envp, envlen, list, 11) ;
    if (popped < 0) strerr_diefu1sys(111, "pop environment") ;
    if (!envalloc_make(&w, envlen - popped, sa.s, sa.len)
     || !envalloc_0(&w))
      strerr_diefu1sys(111, "make envalloc") ;
    pathexec_run(v.s[0], v.s, w.s) ;
    /* envalloc_free(&w) ; stralloc_free(&sa) ; */
  }
  strerr_dieexec(111, v.s[0]) ;
}
