#include "sgetopt.h"
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"

char const *PROG = "shift" ;
#define USAGE "shift [ -n arg# ] [ -b block# ] prog..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  unsigned int b = 0 ;
  unsigned int strict = el_getstrict() ;
  unsigned int n, sharp ;
  {
    unsigned char none = 1 ;
    register int opt ;
    while ((opt = subgetopt(argc, argv, "n:b:")) != opteof)
      switch (opt)
      {
        case 'n' :
          if (!uint0_scan(optarg, &n)) strerr_dieusage(100, USAGE) ;
          none = 0 ;
          break ;
        case 'b' :
          if (!uint0_scan(optarg, &b)) strerr_dieusage(100, USAGE) ;
          none = 0 ;
          break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
    if (none) n = 1 ;
  }
  if (!argc) strerr_dieusage(100, USAGE) ;
  {
    char const *x = env_get2(envp, "#") ;
    if (!x) strerr_dienotset(100, "#") ;
    if (!uint0_scan(x, &sharp)) strerr_dieinvalid(100, "#") ;
  }


 /* Shift n args */

  if (n > sharp)
  {
    if (strict)
    {
      char fmtn[FMT_ULONG] ;
      char fmtsharp[FMT_ULONG] ;
      fmtn[uint_fmt(fmtn, n)] = 0 ;
      fmtsharp[uint_fmt(fmtsharp, sharp)] = 0 ;
      if (strict == 1)
        strerr_warnwu5x("shift", " ", fmtn, " arguments: got ", fmtsharp) ;
      else
        strerr_diefu5x(100, "shift", " ", fmtn, " arguments: got ", fmtsharp) ;
    }
    n = sharp ;
  }


 /* Shift b blocks */

  {
    register unsigned int i = 0 ;
    for (; i < b ; i++)
    {
      for (;;)
      {
        char const *x ;
        char fmt[FMT_ULONG] ;
        unsigned int base = n ;
        fmt[uint_fmt(fmt, ++n)] = 0 ;
        if (n > sharp)
        {
          char fmti[FMT_ULONG] ;
          fmti[uint_fmt(fmt, i)] = 0 ;
          strerr_diefu6x(100, "shift", " block ", fmti, ": too few arguments (", fmt, ")") ;
        }
        x = env_get2(envp, fmt) ;
        if (!x) strerr_dief2x(100, "unset variable ", fmt) ;
        if ((x[0] == ';') && !x[1]) break ;
        if ((x[0] != '~') && strict)
        {
          char fmti[FMT_ULONG] ;
          char fmtp[FMT_ULONG] ;
          fmti[uint_fmt(fmti, i)] = 0 ;
          fmtp[uint_fmt(fmtp, n - base)] = 0 ;
          if (strict == 1)
            strerr_warnw6x("unquoted positional ", x, " at block ", fmti, " position ", fmtp) ;
          else
            strerr_dief6x(100, "unquoted positional ", x, " at block ", fmti, " position ", fmtp) ;
        }
      }
    }
  }


 /* n = shift value; modify the env */

  {
    register unsigned int i = 1 ;
    char fmt[FMT_ULONG] ;
    fmt[uint_fmt(fmt, sharp - n)] = 0 ;
    if (!pathexec_env("#", fmt)) goto err ;
    for (; i <= sharp ; i++)
    {
      char fmu[FMT_ULONG] ;
      fmt[uint_fmt(fmt, i)] = 0 ;
      fmu[uint_fmt(fmu, i + n)] = 0 ;
      if (!pathexec_env(fmt, i <= (sharp - n) ? env_get2(envp, fmu) : 0))
        goto err ;
    }
  }
  pathexec(argv) ;
  strerr_dieexec(111, argv[0]) ;

err:
  strerr_diefu1sys(111, "shift") ;
}
