#include <sys/types.h>
#include <sys/stat.h>
#include "fmtscan.h"
#include "strerr2.h"
#include "djbunix.h"

char const *PROG = "umask" ;
#define USAGE "umask value prog..."

int main (int argc, char const *const *argv, char const *const *envp)
{
  unsigned int m ;
  if (argc < 3) strerr_dieusage(100, USAGE) ;
  if (!oint_scan(argv[1], &m)) strerr_dieusage(100, USAGE) ;
  umask(m) ;
  pathexec_run(argv[2], argv+2, envp) ;
  strerr_dieexec(111, argv[2]) ;
}
