#include "bytestr.h"
#include "strerr2.h"
#include "djbunix.h"

char const *PROG = "unexport" ;
#define USAGE "unexport variable prog..."

int main (int argc, char const *const *argv)
{
  if (argc < 3) strerr_dieusage(100, USAGE) ;
  if (argv[1][str_chr(argv[1], '=')])
    strerr_dief2x(100, "invalid variable name: ", argv[1]) ;
  if (!pathexec_env(argv[1], 0))
    strerr_diefu3sys(111, "remove ", argv[1], " from environment") ;
  pathexec(argv+2) ;
  strerr_dieexec(111, argv[2]) ;
}
