#include <sys/types.h>
#include <sys/wait.h>
#include "sgetopt.h"
#include "fmtscan.h"
#include "gen_alloc.h"
#include "strerr2.h"
#include "djbunix.h"
#include "execline.h"
#include "uintalloc.h"

char const *PROG = "wait" ;
#define USAGE "wait [ -r ] [ ~pid... ] ; [ command... ]"

static unsigned int waitall ()
{
  register unsigned int n = 0 ;
  int wstat ;
  while (wait(&wstat) > 0) n++ ;
  return n ;
}

int main (int argc, char const **argv, char const *const *envp)
{
  int argc1 ;
  unsigned char flagreap = 0 ;
  {
    register int opt ;
    while ((opt = subgetopt(argc, argv, "r")) != opteof)
      switch (opt)
      {
        case 'r' : flagreap = 1 ; break ;
        default : strerr_dieusage(100, USAGE) ;
      }
    argc -= optind ;
    argv += optind ;
  }
  argc1 = el_semicolon(argv) ;
  if (argc1 >= argc) strerr_dief1x(100, "unterminated block") ;
  if (!argc1) flagreap ? wait_reap() : waitall() ;
  else
  {
    uintalloc tab = GEN_ALLOC_ZERO ;
    register unsigned int i = 0 ;
    if (!uintalloc_ready(&tab, argc1))
      strerr_diefu1sys(111, "create pid array") ;
    for (; i < (unsigned int)argc1 ; i++)
    {
      if (!uint0_scan(argv[i], tab.s + i))
        strerr_dieusage(100, USAGE) ;
      tab.len++ ;
    }
    if (waitn(tab.s, tab.len) == -1) strerr_diefu1sys(111, "wait") ;
    uintalloc_free(&tab) ;
  }
  pathexec0_run(argv + argc1 + 1, envp) ;
  strerr_dieexec(111, argv[argc1 + 1]) ;
}
