#! /bin/sh
################################################################################
# File     : mn.sh
# Version  : Exiv2-0_5_040913 1.4
# Author(s): Andreas Huggel (ahu) <ahuggel@gmx.net>
# History  : 08-Mar-04, ahu: created
#
# Description: 
#  Create a module mn.cpp that depends on all MakerNote subclasses
#  to force initialisation of static data in the corresponding 
#  components when using the static library.
################################################################################

rm -f mn.cpp
echo "// Generated by mn.sh on" `date` "- do not edit" > mn.cpp
for file in *mn.hpp; do
    echo "#include \""$file"\"" >> mn.cpp
done
echo "namespace {" >> mn.cpp
for file in *mn.hpp; do
    awk '
      /class .*MakerNote.*:/ { 
          name = $2;
          sub(/MakerNote.*/, "mn", name);
          printf "    Exiv2::%s %s;\n", $2, tolower(name);
      }' $file >> mn.cpp
done
echo "}" >> mn.cpp
