
#ifndef __DEBUG_H
#define __DEBUG_H

#if defined(__DEBUG__) || defined(ENABLE_DEBUG_LOGGING)
#		include <stdio.h>
#   define DEBUG(format, args...) fprintf (stderr, format, ## args)
#else
#   define NDEBUG   /* to disable assert() */
#   define DEBUG(format, args...)
#endif

#define MARK fprintf(stderr, "%s: %s: %d: marked\n", __FILE__, __PRETTY_FUNCTION__, __LINE__)

#ifdef DMALLOC
#   include <dmalloc.h>
#   define new D_NEW
#endif

#include <assert.h>

#endif
