//  general.h
/* 
 *  part of ezbounce
 */

#ifndef __general_h
#define __general_h

#include <sys/types.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <unistd.h>
#ifdef HAVE_STDARG_H
#include <stdarg.h>
#endif
#include <netinet/in.h>
#include <sys/socket.h>
#include <time.h>
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#include <arpa/inet.h>
#include <netdb.h>
#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

extern int   gettok(const char *text, char *buffer, unsigned long, char sep, int, bool = 0);
extern char * gettok_ptr(char *, char, int);
extern int   fdprintf(int, const char *format, ...);
extern int   safe_strcpy(char *dest, const char *src, unsigned long maxsize);
extern int   wild_match(const char *mask,const char *name);
extern int   fill_in_addr(const char *, struct in_addr *); 
extern int   recv_test(int);
extern bool  resolve_address(const char *, struct sockaddr_in *);
extern bool  reverse_lookup(const char *host, char *buffer, u_long );
extern void  duration(time_t, bool, char *, unsigned long);
extern bool  ischan(const char *);

extern       char * my_strndup(const char *, u_long = 0);
extern       char * my_strdup(const char *);

extern char * no_leading(char *orig);
extern const char * no_leading(const char * orig);
extern const char * timestamp(bool = 0);
extern const char * remove_path(const char *);
extern const char * strtrunc(const char *, unsigned long);
extern void  set_dns_timeout(int);

#define nopath remove_path

/* Attempts to make a file descriptor non blocking */
inline bool nonblocking(int fd)
{
    return (fcntl(fd, F_SETFL, fcntl(fd, F_GETFL,0) | O_NONBLOCK) != -1);
}

/* FIXME: check this for robustness */
inline char * ToUpper(char * t)
{
    while (*t)
    {
        *t = toupper(*t);
        t++;
    };
    return t;
}


/* Some systems appear to define this */
#ifdef MAX
#   undef MAX
#endif

inline int MAX(int a, int b)
{
    return (a > b) ? a : b;
}

inline int MAX3(int a, int b, int c)
{
    int d = MAX(a,b);
    return MAX(c,d);
}

#endif  /* __general_h */
