#ifndef __HASH_H
#define __HASH_H


int hash(const char *);

/*
 * this is a skeleton for a chained hash table. Tried to make
 * it somewhat flexible */

class __htbl
{
protected:
	struct node {
		void * data;
		node * next;
	};
		
	struct hashlist {
	    struct node * head;
	    int size;
	};
	
	int list_add(struct hashlist * h, void * data);
	int list_remove(struct hashlist * h, void * data);
	int list_destroy(struct hashlist * h);
	
	int buckets;
	int size;	
	int lookups;
	int hits;
	
	struct hashlist * table;
	
public:
    __htbl(int buckets);
    ~__htbl();

    /* A simple Hash Table Stats interface */
    struct hash_stat_t
    {
        int buckets;
        int size;
        int lookups;
        int hits;
        int sizes[5];       /* buckets with 0, 1, 2, 3, 4+ elements */
    };

    int stat(struct hash_stat_t * ht);
};

#endif /* __HASH_H */
