/*
 *
 * Some routines needed to use mdidentd from C programs.
 *
 * This file is in the public domain.
 *
 * WARRANTIES:
 *  ABSOLUTELY NONE, EITHER EXPRESSED OR IMPLIED.
 * 
 *
 */

#include <sys/types.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/un.h>   
#include <netinet/in.h>              
#include "lib_mdidentd.h"

/*
 * The following is sent to the domain socket, with exact spacing :
 * 
 * localport,remoteport ident
 *
 * example: 2920,6667 fake0000
 */
 
int register_fake_ident(const char * path, const char * ident,
                   unsigned short local_port, unsigned short remote_port)
{
    int sock;
    unsigned len;
    int x, err = IDENT_OK;
    struct sockaddr_un thing;     
    char ident_buff[5 + 1 + 5 + 1 + MAX_IDENT_LENGTH + 3];
    char returned[20];

    sock = socket(AF_UNIX, SOCK_STREAM, 0);
    if (sock < 0)
        return IDENT_ERROR;
    
    thing.sun_family = AF_UNIX;
    thing.sun_path[sizeof(thing.sun_path) - 1] = 0;
    strncpy(thing.sun_path, path, sizeof(thing.sun_path) - 1);
    len = sizeof(thing.sun_family) + strlen(thing.sun_path);
    
    if (connect(sock, (struct sockaddr *) &thing, len))
    {
        close(sock);
        return IDENT_CONNECT_FAILURE;
    }
    
    if (strlen(ident) > MAX_IDENT_LENGTH)
    {
        char * i;
        i = strdup(ident);
        i[MAX_IDENT_LENGTH] = 0;
        sprintf(ident_buff, "%d,%d %s", local_port, remote_port, i);
        free(i);
    } else
        sprintf(ident_buff, "%d,%d %s", local_port, remote_port, ident);

    write(sock, ident_buff, strlen(ident_buff));

    switch (( x = read(sock, returned, sizeof(returned) - 1)))
    {
    case -1: /* Some other error */
    case 0: /* Socket prematurely closed.. */
        err = IDENT_ERROR;
        break;

    default:
        /* Parse the message, check for OK or INVAL, or EXISTS */
        returned[x] = 0;
        if (strcmp(returned, "INVAL") == 0)
            err = IDENT_ERROR_INVAL;
        else if (strcmp(returned, "ERROR") == 0)
            err = IDENT_ERROR;
        else if (strcmp(returned, "EXISTS") == 0)
            err = IDENT_ERROR_EXISTS;
        else if (strcmp(returned, "AUTH") == 0)
            err = IDENT_AUTH_FAILURE;
        else
            err = IDENT_OK;
    }

    close(sock);
    return err;  
}

char const * const ident_error(int err)
{
    switch (err)
    {
    case 1:
        return "No error";
    case IDENT_ERROR_INVAL:
        return "Invalid ident request given";
    case IDENT_ERROR:
        return "Unknown error";
    case IDENT_ERROR_EXISTS:
        return "Ident request already exists";
    case IDENT_CONNECT_FAILURE:
        return "Error connecting to domain socket";
    case IDENT_AUTH_FAILURE:
        return "Authorization denied (possibly bad ident request)";
    }
    return NULL;
}



