// ilist.h

/*
 * a cheesy thing to hold fake idents
 *
 * (C) 1998 Murat Deligonul
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  

 *
 */
#ifndef __ILIST_H
#define __ILIST_H

#include "linkedlist.h" 
#include <time.h>

class ilist 
{
private:
    struct ident_info 
    {
        unsigned short port1, port2;
        char user[24];
        time_t time;
    };
    list<ident_info> ident_list;
    const time_t max_age;    /* how long fake ident requests are allowed to live */
    unsigned long num;

protected:
    ident_info * internal_lookup(unsigned short, unsigned short, const char *, bool);
    
public:
    ilist(time_t);
    ~ilist();
    bool lookup(unsigned short, unsigned short, char *, u_long);
    bool remove(unsigned short, unsigned short, const char *);
    bool kill_expired(time_t);
    int read_from(int);
    int add(const char *, unsigned short, unsigned short);

    unsigned long get_num(void)
    {
        return num;
    }
};
    

#endif
