#!/bin/sh

# borrowed from
# from 'hbnc' package by HoE
#

if [ -z "$1" ] ; then
	echo "Usage: ./makekey.sh [rsa] info"
        echo "info - can be any word, and it should inform the client"
        echo "       about the server he is logging in (for example servername)"
        echo "rsa - if you dont specify this then DSA key will be created"
        echo "certificate is for 365 days and is self-signed"
        exit 1
fi

if [ ! -f `which openssl` ]; then
 echo "openssl not found, please isntall openssl and set path to the binaries..."
 exit 1
fi


if [ -z "$2" ] ; then
	echo "*******************************************************"
	echo "NOTE! ezbounce will only work with RSA keys"
	echo "If this key doesn't work, consider running this script"
	echo "again with the rsa option"
	echo "*******************************************************"
	sleep 4
	type=dsa
	servbase=$1
        base=ezb-dsa
        openssl rand -out gunk 1024
	openssl dsaparam -rand gunk -out $base.dsaparam 1024
	openssl dhparam -rand gunk -out $base.dh 1024
	option=$base.dsaparam
        rm -f gunk	
else
	type=$1
	servbase=$2
	base=ezb-$1
	option=1024
fi

openssl gen$type -out $base.key $option
openssl req -new -x509 -days 365 -key $base.key -out $base.crt 2>/dev/null << EOF
.
.
.
.
.
$servbase
.
EOF

cat $base.key $base.crt > $base.pem

if [ $type = "dsa" ] ; then
	cat $base.dh >> $base.pem
fi

rm -f $base.key $base.crt $base.dh $base.dsaparam
echo 
echo $base.pem created.
echo Copy the file to /usr/local/ssl/certs or leave it in current dir

