
#ifndef __COMMANDS_H
#define __COMMANDS_H

struct cmd;
class htbl;

#include "autoconf.h"
#include "conn.h"
#include "hash.h"

/* work arounds for GCC 2.95.x compiler bug */
#ifdef __GNUC__
#   if __GNUC__ == 2
#       if __GNUC_MINOR__ == 95
#           define GCC_COMPILER_BUG
#       endif
#   endif
#endif

typedef int (conn::*cmd_handler_t)(int, int, char **);

struct cmd {
    const char * msg;                 /* the actual command */
    int id;                           /* numerical id */
    int req_flags;                    /* flags to match */
    int bad_flags;                    /* flags that we can't have */
#ifndef GCC_COMPILER_BUG
    /* pointer to handler function */
    cmd_handler_t handler;
#else
    int idx;
#endif
    const char * help;
};

extern const struct cmd command_table[];
extern const struct cmd incoming_command_table[];

#ifdef GCC_COMPILER_BUG
extern const cmd_handler_t handlers[];
#endif

class htbl : public __htbl
{
public:
    htbl(int buckets) : __htbl(buckets) { }

    int insert(const struct cmd * );
    /* int remove(struct cmd *); -- heh, we don't need one */
    const struct cmd * lookup(const char *, int);

};


/* Commands from clients */
enum {
    CMD_USER,   CMD_NICK,   CMD_PASS,   CMD_CONN,                   CMD_STATUS,
    CMD_KILL,   CMD_DIE,    CMD_REHASH, CMD_DIENOW,     CMD_CANCEL, CMD_HELP,
    CMD_INTERFACE,          CMD_VHOSTS, CMD_WRITE,      CMD_DETACH, CMD_REATTACH,
    CMD_DISCONNECT,         CMD_IDENT,                  CMD_LOG,
    CMD_DCCSEND,            CMD_MOTD,   CMD_QUIT,       CMD_EZBOUNCE,
    CMD_HASH,   CMD_PRIVMSG,            CMD_LOGIN,      CMD_SESSIONS,
    CMD_TRAFFIC,            CMD_WHOIS,  CMD_SET,        CMD_ECHO,   CMD_SAVE,
    CMD_TRACE,  CMD_ALLOWED,            CMD_RELOAD,     CMD_DEBUG,  CMD_ABOUT,
    CMD_VERSION,            CMD_CHATSEND,
    CMD_ZOMBIFY
};

/* Commands from irc server - checked when reattaching or connecting */
enum {
    INCOMING_003 = 100, INCOMING_004,       INCOMING_005,
    INCOMING_PRIVMSG,   INCOMING_MODE,      INCOMING_NICK,
    INCOMING_JOIN,      INCOMING_PART,      INCOMING_KICK,
    INCOMING_TOPIC,     INCOMING_NOTICE,    INCOMING_QUIT,
    INCOMING_PING,      INCOMING_PONG,      INCOMING_ERROR

};

#endif /* __COMMANDS_H */
