// config.h 

#ifndef __config_h
#define __config_h

struct proxy_options;

#include <stdlib.h>
#include "general.h"
#include "linkedlist.h"
#include "user.h"


extern int reload_config_file(const char *file);
extern int load_config_file(const char *file, struct proxy_options *,
    list<userdef> **, list<ruleset> **, list<char> **);

extern struct proxy_options pcfg;
extern list<char> * vhosts;


enum {
     DEF_MIN_BUFFER_SIZE = 128,
     DEF_MAX_BUFFER_SIZE = 32768,
     DEF_MAX_IDLE_TIME = 0,
     DEF_MAX_REGISTER_TIME = 25,
     DEF_MAX_DNS_WAIT_TIME = 15,
     DEF_MAX_SOCKETS  = 256
};


enum {
    SILENT_REJECTION      = 0x4,
    KILL_WHEN_FULL        = 0x8,
    PREVENT_SELF_CONNECTS = 0x10,
    NO_REVERSE_LOOKUPS    = 0x20
};


/* Global ezb options. Not configurable
 * on a per-user basis, so only one copy. */
struct proxy_options
{
    char * ports;
    char * sslports;
    char * dcc_ports;
    char * logdir;
    char * configfile;
    char * logfile;
    char * pidfile;
    char * certfile;
    char * motdfile;
    char * userfile;

    time_t max_register_time;               /* time limit for user to register w/ proxy */
    unsigned max_failed_passwords;
    unsigned long   min_buffer_size,
                    max_buffer_size,
                    max_sockets,            /* size of socket table */
                    max_dns_wait_time;      /* how long to wait for dns */

    int flags;                              /* boolean vars */
    struct in_addr iface_listen;            /* vhost to listen on */
};

#endif

