/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "messages.h"

HELP_ENTRY(command_list,
                   "\002Available commands\002:\r\n"
                   "    user        nick        pass        login\r\n"
                   "    conn        cancel      vhost       vhosts\r\n"
                   "    detach      log         ident       reattach\r\n"
                   "    quit        set         echo        disconnect\r\n"
                   "    traffic     allowed     trace       sessions\r\n"
                   "    motd        ezb         save        help\r\n"
                   "    version     about       debug\r\n"
                   "\r\n"
                   "\002Available admin commands\002\r\n"
                   "    status      kill        die         dienow\r\n"
                   "    rehash      reload      write       hash\r\n"
                   "    whois\r\n" );

HELP_ENTRY(user,   "user <arguments>\r\n"
                   "    Just like the standard IRC command, your client\r\n"
                   "    sends this to begin the process of logging into ezbounce\r\n" );

HELP_ENTRY(nick,   "nick <nickname>\r\n"
                   "    Just like the standard IRC command, this changes your\r\n"
                   "    nickname. It doesn't require you to use /quote -- what\r\n"
                   "    a deal\r\n");

HELP_ENTRY(pass,   "pass <password> [auto-server]\r\n"
                   "pass <username>:<password> [auto-server]\r\n"
                   "    Logs you into ezbounce\r\n"
                   "    By default, will log-in as user 'default'\r\n"
                   "    You can, however, specify a username to login as.. \r\n"
                   "    e.g. pass bob:mypass\r\n");

HELP_ENTRY(login,  "login <username> <password> [auto-server]\r\n"
                   "    Logs you into the proxy. You can specify an optional server\r\n"
                   "    to connect to\r\n");
#ifdef _USE_SSL
HELP_ENTRY(conn,   "conn [-ssl] <server>[:port] [password]\r\n"
                   "    Connects you to an IRC server\r\n"
                   "    You can use the -ssl switch to create an SSL connection\r\n");
#else
HELP_ENTRY(conn,   "conn <server>[:port] [password]\r\n"
                   "    Connects you to an IRC server\r\n");
#endif

HELP_ENTRY(cancel, "cancel\r\n"
                   "    Cancels a connection attempt\r\n");

HELP_ENTRY(help,   "help <command>\r\n"
                   "    The pimpin' ezb help system\r\n");

HELP_ENTRY(vhost,  "vhost <interface>\r\n"
                   "    Changes the connection interface (or virtual host) used\r\n"
                   "    when you connect to an IRC server\r\n");

HELP_ENTRY(vhosts, "vhosts\r\n"
                   "    Displays a list of virtual hosts available for your use\r\n");

HELP_ENTRY(detach, "detach [password]\r\n"
                   "    Detaches you from the proxy. This means you will be\r\n"
                   "    disconnected from ezbounce, but your connection to\r\n"
                   "    the IRC server will remain alive\r\n"
                   "    Password is optional; however it is required\r\n"
                   "    for 'default' users\r\n" );

HELP_ENTRY(reattach, "reattach <id> [password]\r\n"
                   "    Attaches you back to an IRC session\r\n");

HELP_ENTRY(disconnect, "disconnect\r\n"
                   "    Disconnects you from the IRC server -- You will remain\r\n"
                   "    connected to ezbounce\r\n");

HELP_ENTRY(ident,   "ident <fake-ident>\r\n"
                   "    For use with the mdidentd server\r\n"
                   "    Sets a fake ident reply\r\n");

HELP_ENTRY(log,    "log <options> <arguments>\r\n"
                   "-------------------------------------------\r\n"
                   "- Available LOG Commands:\r\n"
                   "-\r\n"
                   "- SET <any combination of tfpcans>\r\n"
                   "-\r\n"
                   "-      Sets logging options for this session\r\n"
                   "-      p - log private messages\r\n"
                   "-      c - log channel messages\r\n"
                   "-      a - log both channel and private\r\n"
                   "-      n - don't log anything\r\n"
                   "-      s - log to seperate files\r\n"
                   "-      t - timestamp logs\r\n"
                   "-      f - show full addresses in *public* messages\r\n"
                   "-\r\n"
                   "-\r\n"
                   "- SEND <# or ALL>\r\n"
                   "-\r\n"
                   "-     Sends any logfiles to you that are ready to be sent.\r\n"
                   "-     You specify which one to receive or to receive two at a time.\r\n"
                   "-\r\n"
                   "-\r\n"
                   "- VIEW <# or ALL>\r\n"
                   "-\r\n"
                   "-     Lets you view log files, by opening a DCC CHAT.\r\n"
                   "-\r\n"
                   "-\r\n"
                   "- FIND <password>\r\n"
                   "-\r\n"
                   "-     Allows you to recover log files from old detached\r\n"
                   "-     sessions that you were not able to retrieve\r\n"
                   "-     ID and Password refer to the magic number and password\r\n"
                   "-     of the session whose logs you want to retrieve\r\n"
                   "-\r\n"
                   "-\r\n"
                   "- LIST\r\n"
                   "-     Lists the results of your previous LOG FIND search and \r\n"
                   "-     and any other log files that are ready to be sent.\r\n"
                   "-\r\n"
                   "-\r\n"
                   "- Use /LOG without any options to view current log settings\r\n");

HELP_ENTRY(motd,   "motd\r\n"
                   "    Shows the message of the day (if available)\r\n");

HELP_ENTRY(quit,   "quit <reason>\r\n"
                   "    If auto-detach is enabled, use `/quote ezb quit'\r\n"
                   "    to quit from the IRC server and not detach\r\n");

HELP_ENTRY(ezbounce, "ezb <command> [args]\r\n"
                   "    Lets you use proxy commands while connected to an IRC server\r\n");

HELP_ENTRY(sessions, "sessions\r\n"
                   "    Displays your current detached IRC sessions\r\n");

HELP_ENTRY(traffic,"traffic\r\n"
                   "    Displays some stats about amount of data transferred from\r\n"
                   "    ezbounce to/from clients and IRCservers\r\n");

HELP_ENTRY(set,    "set <variable> <value>\r\n"
                   "    Allows you configure various personal perferences\r\n");

HELP_ENTRY(about,  "about\r\n"
                    "   Shows some info about this program\r\n");

HELP_ENTRY(version,"version\r\n"
                    "   Displays the ezbounce and OS version\r\n");

HELP_ENTRY(debug,  "debug\r\n"
                    "   Various debugging utilities. \r\n"
                    "   NOTE: Not enabled by default.\r\n");

HELP_ENTRY(echo,   "echo <text>\r\n"
                   "    ditto\r\n");

HELP_ENTRY(save,   "save\r\n"
                   "    For admins, saves all user preferences to disk\r\n"
                   "    For normal users, copies your preferences so that future\r\n"
                   "    logins will retain the settings\r\n"
                   "    Not available to 'default' user\r\n");

HELP_ENTRY(trace,  "trace <id>\r\n"
                   "    Displays network details about a user's connections\r\n");

HELP_ENTRY(allowed,"allowed\r\n"
                   "    Displays configuration settings for your user\r\n");


HELP_ENTRY(status, "status\r\n"
                   "    Displays proxy uptime and list of users\r\n"
                   "    The 'STAT' field contains one or more of the following flags:\r\n"
                   "     r  -- registered (user/nick received)   \r\n"
                   "     p  -- logged in\r\n"
                   "     a  -- administrator\r\n"
                   "     c  -- connecting to IRC server\r\n"
                   "     b  -- bounced\r\n"
                   "     d  -- detached\r\n"
                   "     w  -- waiting (newly connected)\r\n");

HELP_ENTRY(kill,   "kill <id> <reason>\r\n"
                   "    Kills a user off the proxy\r\n");

HELP_ENTRY(die,    "die <reason>\r\n"
                   "    Terminates the IRC proxy gracefully\r\n");

HELP_ENTRY(rehash, "rehash\r\n"
                   "    Attempts to reload the configuration file\r\n");

HELP_ENTRY(dienow, "dienow <reason>\r\n"
                   "    Terminates the IRC proxy immediately\r\n");

HELP_ENTRY(whois,  "whois <username or id>\r\n"
                   "    Displays information about a particular user\r\n");

HELP_ENTRY(hash,   "hash <table #>\r\n"
                   "    Displays some debugging info for the internal hash tables\r\n");

HELP_ENTRY(write,  "write <id> <message>\r\n"
                   "    Sends a message to user 'id'\r\n");

HELP_ENTRY(reload,  "reload\r\n"
                   "    Reloads the user preferences file from disk\r\n");

