/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "autoconf.h"

#include <stdio.h>
#include <string.h>

#include "ircaddr.h"
#include "general.h"
#include "debug.h"

/*
 * input must be in the form:
 *   nickname!username@host.blahblah
 * We don't handle corrupt input particularly well!!
 */
ircaddr::ircaddr(const char * addr)
{
    addr = no_leading(addr);
    nick = host = ident = 0;
    DEBUG("\tircaddr::ircaddr() -- %s\n", addr);
    /* we work backwards -- get the host first */
    char * t = strrchr(addr, '@');
    if (t)
        host = my_strdup(t+1);

    /* get the nick */
    char * e = strchr(addr, '!');
    if (e)
    {
        nick = my_strndup(addr, e-addr);
        ident = my_strndup(e+1, t ? (t - e  - 1) : 0);
    }
    else
        nick = my_strdup(addr);
}

ircaddr::ircaddr(__ircaddr &i2)
{
    nick = my_strdup(i2.nick);
    host = my_strdup(i2.host);
    ident = my_strdup(i2.ident);
}

ircaddr::~ircaddr()
{
    delete[] nick;
    delete[] host;
    delete[] ident;
}

ircaddr_simple::ircaddr_simple(char * addr)
{
    DEBUG("\tircaddr_simple::ircaddr_simple() -- %s\n", addr);
    nick = addr = no_leading(addr);
    host = ident = 0;
    char * e = strchr(addr, '!');
    if (e)
    {
        *e = 0;
        nick = addr;
        ident = e+1;
        e = strchr(ident, '@');
        if (e)
        {
            *e = 0;
            host = e + 1;
        }
    }
}
