/*
 * logfile.h
 *
 * (c) 1999-2001 Murat Deligonul
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  
 *
 */

 
#ifndef __LOGFILE_H
#define __LOGFILE_H

class logfile;

#include "ircaddr.h"
#include "linkedlist.h"

           
class logfile
{
public:
    logfile(const char * basedir, const char * owner,
            int id, int options, int maxsize,
            const char *, int * result);
    ~logfile();

    int  write(int, const __ircaddr *, const char *, char *, const char *);
    int  dump(const char *);    /* Write raw text to log */
    void stop(void);            /* Stop logging */
    int  get_filenames(char *f[2]);

    /* The various log options */
    enum {                      /* Log file options */
        LOG_NONE     = 0,       /* Do not log */
        LOG_PRIVATE  = 2,       /* Log private messages */
        LOG_CHANNEL  = 4,       /* Log messages to channel */
        LOG_PUBLIC   = 4,
        LOG_ALL      = 6,       /* Log all of them */
        LOG_SEPERATE = 8,       /* Log to seperate files */
        LOG_FULL_ADDRS = 16,    /* Full-user address in public messages */
        LOG_TIMESTAMP = 32      /* Log all events with a timestamp */
    };

    /* Not Log options, but flags given to write(); */
    enum {
        EVENT_OTHER   =  1,
        EVENT_PRIVATE =  2,
        EVENT_PUBLIC  =  4,
        EVENT_CTCP    =  8,
        EVENT_NOTICE  = 16,
        EVENT_KICK    = 32,
        EVENT_JOIN    = 64,
        EVENT_PART    = 128,
        EVENT_MODE    = 256,
        EVENT_TOPIC   = 512,
        EVENT_NICK    = 1024,
        EVENT_QUIT    = 2048
    };


    static int charflags_to_int(const char *);
    static int intflags_to_char(int, char *);
    static int find_log_files(const char * basedir, const char * nickname, 
                                         const char * password, int id, strlist * plist, int max);
private:
    /* fd2 is always private message log file fd.
     * fd1 is always chan message log file fd.
     * They are both always valid file descriptors
     * (so the may equal each other)
     */
    int options, fd1, fd2, maxsize;
    unsigned long size1, size2; /* How big are the files */
    char * log1;                /* Both only needed when sending */
    char * log2;                /* log files back to user */
    
public:
    const char * get_log1(void) { return log1; }
    const char * get_log2(void) { return log2; }

    static const char * fixup_logname(const char * filename);

    /* need to keep track of which log files are active, that is:
     *   -- currently being written to
     *   -- waiting to be sent
     *   -- being sent
     */
    static int lock(const char * file);
    static int release(const char * file);
    static int is_locked(const char * file);

private:
    static strlist active_logs;
    static int strip_burc_codes(char * text);
    static int mkname(const char * basedir, const char * owner, int id, 
                                 const char * pw, const char * type, char * buff);
};
  

#endif /* __LOGFILE_H */
