// server.h

#ifndef __server_h
#define __server_h

#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <time.h>

#include "user.h"

/* #define ENABLE_DEBUG_LOGGING */

extern int start_proxy(void);
extern int stop_proxy(void);
    
extern int ircproxy_listen(unsigned short, const struct in_addr *,int);
extern int ircproxy_die(bool now, const char *);
extern int ircproxy_startlog(const char *);
extern int ircproxy_closelog(void);
extern int ircproxy_save_prefs(list<userdef> *, const char *);
extern int ircproxy_load_prefs(list<userdef> *, const char *);

extern void ircproxy_request_rehash(void);
extern void ircproxy_redir_stdxxx(void);
extern int  ircproxy_rehash(void);
extern list<conn> * ircproxy_conn_list(void);

/* The logging system */
extern int printlog(const char *format, ...);

/*
 * Somewhere to hold the current time while we process the conn
 * objects requests so that they don't call time(2) a billion
 * more times.
 */

inline time_t ircproxy_time(void)
{
    extern time_t time_ctr;
    return time_ctr;
}


inline time_t update_time_ctr(void)
{
    extern time_t time_ctr;
    return (time_ctr = ::time(NULL));
}
#endif
