/**
 * timer.h
 */

#ifndef __TIMER_H
#define __TIMER_H

#include <time.h>

#include "linkedlist.h"

class timer {

private:
	int id;				/* an id for this timer. defaults to zero */
	int interval;			/* how often this timer is executed */
	int options;			/* timer options */
	time_t epoch;			/* when we started */

	static list<timer> timers;
	static int poll_interval;
	static time_t counter;

public:
	timer(int, int = 0, int = 0);
	virtual ~timer();

	static int enable(timer *);
	static int disable(timer *);
	static int poll(time_t);
	static int get_poll_interval() { return poll_interval; }
	static int get_num_active() { return timers.size(); }

	int enable(void) { return enable(this); }
	int disable(void) { return disable(this); }
	int get_id() const { return id; }
	int get_interval() const { return interval; }
	int get_options()  const { return options; }
	time_t get_epoch() const { return epoch; }
	void reset() { epoch = counter; }


	/**
	 * Various timer options:
	 * 	TIMER_ONESHOT:		execute only once
	 */
	enum {
		TIMER_ONESHOT = 0x2,
	};

private:
	static int calc_interval();
	static int gcd(int ,int);
	static int gcd(int *, int);

protected:
	/**
	 * For all timer_procs:
	 * 	return <  0 	-- to disable timer after this execution
	 *	return => 0	-- ignored
	 *
	 * never call enable() or disable() in here cause it will screw
	 * with the list while the iterator is traversing it
	 */
	virtual int timer_proc(time_t) = 0;
};

/**
 * Lets you make simple timers without having to
 * bother with deriving classes
 */
class generic_timer : public timer
{
public:
	typedef int (*gtfn)(time_t, int, void *);

private:
	void * data;
	gtfn callback;
	virtual int timer_proc(time_t);

public:
	generic_timer(int _int, gtfn _callback,
			void * d = 0, int _opt = 0, int _id = 0)
		: timer(_int, _opt, _id)
	{
		data = d;
		callback = _callback;
	}
};

#endif
