/*
*  Copyright (c) 1998
*  Steven G. Kargl.  All rights reserved.
*
*  This code is committed to the public domain.
*/
#include <sys/time.h>
#include <sys/resource.h>

double etime_(float *it) {

	struct rusage rt;

	if (getrusage(RUSAGE_SELF, &rt) == 0) {
		*it     = (rt.ru_utime.tv_sec + 1.e-6 * rt.ru_utime.tv_usec);
		*(it+1) = (rt.ru_stime.tv_sec + 1.e-6 * rt.ru_stime.tv_usec);
	} else
	   *it = *(it+1) = - 1.;
		
	return (*it + *(it+1));
}
