/*
 * Decompiled with CFR 0.152.
 */
package FesiForm;

import FESI.jslib.JSException;
import FESI.jslib.JSObject;
import FesiForm.GuiContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class DefaultDocumentHandler
implements DocumentHandler {
    protected boolean trace;
    protected GuiContext guiContext;

    public DefaultDocumentHandler(GuiContext guiContext, boolean bl) {
        this.trace = bl;
        this.guiContext = guiContext;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        System.out.println("CHARACTERS: [[" + new String(cArray) + "]]");
        throw new SAXException("Unexpected CHARACTERS ignored");
    }

    public void endDocument() throws SAXException {
        if (this.trace) {
            System.out.println("END_DOCUMENT");
        }
        throw new SAXException("Unexpected END_DOCUMENT ignored");
    }

    public void endElement(String string) throws SAXException {
        if (this.trace) {
            System.out.println("END_ELEMENT: </" + string + ">");
        }
        throw new SAXException("Unexpected END_ELEMENT ignored");
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.trace) {
            System.out.println("IGNORABLE_WHITESPACE: " + n2);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.trace) {
            System.out.println("PROCESSING_INSTRUCTIONS: '" + string2 + "'");
        }
        throw new SAXException("Unexpected PROCESSING_INSTRUCTIONS ignored");
    }

    public void setDocumentLocator(Locator locator) {
        if (this.trace) {
            System.out.println("SET_DOCUMENT_LOCATOR: " + locator);
        }
    }

    public void startDocument() throws SAXException {
        if (this.trace) {
            System.out.println("START_DOCUMENT");
        }
        throw new SAXException("Unexpected START_DOCUMENT ignored");
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.trace) {
            System.out.println("START_ELEMENT: <" + string + ">, " + attributeList.getLength() + " attribute(s)");
        }
        throw new SAXException("Unexpected START_ELEMENT ignored");
    }

    public void processEnd(String string) throws SAXException {
        throw new SAXException("Unexpected PROCESS END ignored");
    }

    String getAttribute(String string, AttributeList attributeList) {
        int n = 0;
        while (n < attributeList.getLength()) {
            if (string.equals(attributeList.getName(n))) {
                return attributeList.getValue(n);
            }
            ++n;
        }
        return null;
    }

    protected void processComponentAttributes(Component component, AttributeList attributeList) throws SAXException {
        this.processBG(component, attributeList);
        this.processFG(component, attributeList);
        this.processFONTs(component, attributeList);
        this.processSIZE(component, attributeList);
        this.processLOCATION(component, attributeList);
        this.processToolTipText(component, attributeList);
        this.processPopupId(component, attributeList);
    }

    protected void processJComponentAttributes(JComponent jComponent, AttributeList attributeList) throws SAXException {
        this.processOPAQUE(jComponent, attributeList);
        this.processMINIMUMSIZE(jComponent, attributeList);
        this.processMAXIMUMSIZE(jComponent, attributeList);
        this.processPREFERREDSIZE(jComponent, attributeList);
        this.processBOUNDS(jComponent, attributeList);
    }

    protected void processPopupId(Component component, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("popupId", attributeList);
        if (string != null) {
            Component component2 = (Component)this.guiContext.getById(string);
            if (component2 == null) {
                throw new SAXException("Popup id=" + string + " not found");
            }
            if (component2 instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = (JPopupMenu)component2;
                component.addMouseListener(new 1(jPopupMenu));
                return;
            }
            throw new SAXException("Element id " + string + " is not a JPopupMenu");
        }
    }

    protected void processToolTipText(Component component, AttributeList attributeList) {
        String string = this.getAttribute("toolTipText", attributeList);
        if (string != null && component instanceof JComponent) {
            if (this.trace) {
                System.out.println("  TOOLTIPTEXT=" + string);
            }
            ((JComponent)component).setToolTipText(string);
        }
    }

    protected void processOptionalId(Component component, AttributeList attributeList) {
        String string = this.getAttribute("id", attributeList);
        if (string != null) {
            if (this.trace) {
                System.out.println("  ID=" + string);
            }
            this.guiContext.putId(string, component);
        }
    }

    protected Dimension processSIZE(Component component, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("size", attributeList);
        if (string != null) {
            int n;
            int n2;
            if (string.charAt(0) != '(') {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            int n3 = string.indexOf(",");
            if (n3 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string2 = string.substring(1, n3);
            int n4 = string.indexOf(")", n3);
            if (n4 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string3 = string.substring(n3 + 1, n4);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            if (this.trace) {
                System.out.println("  SIZE: (" + n2 + "," + n + ")");
            }
            component.setSize(n2, n);
            return new Dimension(n2, n);
        }
        return null;
    }

    protected Point processLOCATION(Component component, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("location", attributeList);
        if (string != null) {
            int n;
            int n2;
            if (string.charAt(0) != '(') {
                throw new SAXException("Location format is (x,y), not: " + string);
            }
            int n3 = string.indexOf(",");
            if (n3 < 1) {
                throw new SAXException("Location format is (x,y), not: " + string);
            }
            String string2 = string.substring(1, n3);
            int n4 = string.indexOf(")", n3);
            if (n4 < 1) {
                throw new SAXException("Location format is (x,y), not: " + string);
            }
            String string3 = string.substring(n3 + 1, n4);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Location format is (x,y), not: " + string);
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Location format is (x,y), not: " + string);
            }
            if (this.trace) {
                System.out.println("  LOCATION: (" + n2 + "," + n + ")");
            }
            component.setLocation(n2, n);
            return new Point(n2, n);
        }
        return null;
    }

    protected Color processBG(Component component, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("bg", attributeList);
        Color color = null;
        if (string != null) {
            color = this.colorByName(string);
            if (this.trace) {
                System.out.println("  BG: " + string);
            }
            if (color != null) {
                component.setBackground(color);
            }
        }
        return color;
    }

    protected Color processFG(Component component, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("fg", attributeList);
        Color color = null;
        if (string != null) {
            color = this.colorByName(string);
            if (this.trace) {
                System.out.println("  FG: " + string);
            }
            if (color != null) {
                component.setForeground(color);
            }
        }
        return color;
    }

    protected Font processFONTs(Component component, AttributeList attributeList) throws SAXException {
        Font font = null;
        String string = this.getAttribute("fontFace", attributeList);
        String string2 = this.getAttribute("fontSize", attributeList);
        String string3 = this.getAttribute("fontStyle", attributeList);
        boolean bl = false;
        if (string != null) {
            bl = true;
        } else {
            string = "Serif";
        }
        if (string2 != null) {
            bl = true;
        }
        if (string3 != null) {
            bl = true;
        }
        int n = 10;
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Bad font size: " + string2);
            }
        }
        int n2 = 0;
        if (string3 != null) {
            n2 = this.styleByName(string3);
        }
        if (bl) {
            if (this.trace) {
                System.out.println("  FONT: " + string + ", " + n2 + ", " + n);
            }
            font = new Font(string, n2, n);
            component.setFont(font);
        }
        return font;
    }

    protected Icon processAbstractButtonICON(AbstractButton abstractButton, AttributeList attributeList) {
        ImageIcon imageIcon = null;
        String string = this.getAttribute("icon", attributeList);
        if (string != null) {
            imageIcon = new ImageIcon(string);
            if (this.trace) {
                System.out.println("  ICON: " + string);
            }
            abstractButton.setIcon(imageIcon);
        }
        return imageIcon;
    }

    protected char processMNEMONIC(AbstractButton abstractButton, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("mnemonic", attributeList);
        char c = '\u0000';
        if (string != null && string.length() > 0) {
            c = string.charAt(0);
            if (this.trace) {
                System.out.println("  MNEMONIC: " + c);
            }
            abstractButton.setMnemonic(c);
        }
        return c;
    }

    protected Icon processDISABLEDICON(AbstractButton abstractButton, AttributeList attributeList) {
        ImageIcon imageIcon = null;
        String string = this.getAttribute("disabledIcon", attributeList);
        if (string != null) {
            imageIcon = new ImageIcon(string);
            if (this.trace) {
                System.out.println("  DISABLEDICON: " + string);
            }
            abstractButton.setDisabledIcon(imageIcon);
        }
        return imageIcon;
    }

    protected boolean processSELECTED(AbstractButton abstractButton, AttributeList attributeList) throws SAXException {
        boolean bl = false;
        String string = this.getAttribute("selected", attributeList);
        if (string != null) {
            string = string.toLowerCase();
            if (this.trace) {
                System.out.println("  SELECTED: " + string);
            }
            if (string.equals("true")) {
                bl = true;
            } else if (!string.equals("false")) {
                throw new SAXException("Bad true/false value for selected: " + string);
            }
            abstractButton.setSelected(bl);
        }
        return bl;
    }

    protected boolean processBORDERPAINTED(AbstractButton abstractButton, AttributeList attributeList) throws SAXException {
        boolean bl = false;
        String string = this.getAttribute("borderPainted", attributeList);
        if (string != null) {
            string = string.toLowerCase();
            if (this.trace) {
                System.out.println("  BORDERPAINTED: " + bl);
            }
            if (string.equals("true")) {
                bl = true;
            } else if (!string.equals("false")) {
                throw new SAXException("Bad true/false value for selected: " + bl);
            }
            abstractButton.setBorderPainted(bl);
        }
        return bl;
    }

    protected boolean processFOCUSPAINTED(AbstractButton abstractButton, AttributeList attributeList) throws SAXException {
        boolean bl = false;
        String string = this.getAttribute("focusPainted", attributeList);
        if (string != null) {
            string = string.toLowerCase();
            if (this.trace) {
                System.out.println("  FOCUSPAINTED: " + bl);
            }
            if (string.equals("true")) {
                bl = true;
            } else if (!string.equals("false")) {
                throw new SAXException("Bad true/false value for selected: " + bl);
            }
            abstractButton.setFocusPainted(bl);
        }
        return bl;
    }

    protected boolean processENABLED(AbstractButton abstractButton, AttributeList attributeList) throws SAXException {
        boolean bl = false;
        String string = this.getAttribute("enabled", attributeList);
        if (string != null) {
            string = string.toLowerCase();
            if (this.trace) {
                System.out.println("  ENABLED: " + bl);
            }
            if (string.equals("true")) {
                bl = true;
            } else if (!string.equals("false")) {
                throw new SAXException("Bad true/false value for selected: " + bl);
            }
            abstractButton.setEnabled(bl);
        }
        return bl;
    }

    protected Dimension processMINIMUMSIZE(JComponent jComponent, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("minimumSize", attributeList);
        if (string != null) {
            int n;
            int n2;
            if (string.charAt(0) != '(') {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            int n3 = string.indexOf(",");
            if (n3 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string2 = string.substring(1, n3);
            int n4 = string.indexOf(")", n3);
            if (n4 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string3 = string.substring(n3 + 1, n4);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            if (this.trace) {
                System.out.println("  MINIMUMSIZE: (" + n2 + "," + n + ")");
            }
            Dimension dimension = new Dimension(n2, n);
            jComponent.setMinimumSize(dimension);
            return dimension;
        }
        return null;
    }

    protected Dimension processMAXIMUMSIZE(JComponent jComponent, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("maximumSize", attributeList);
        if (string != null) {
            int n;
            int n2;
            if (string.charAt(0) != '(') {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            int n3 = string.indexOf(",");
            if (n3 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string2 = string.substring(1, n3);
            int n4 = string.indexOf(")", n3);
            if (n4 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string3 = string.substring(n3 + 1, n4);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            if (this.trace) {
                System.out.println("  MAXIMUMSIZE: (" + n2 + "," + n + ")");
            }
            Dimension dimension = new Dimension(n2, n);
            jComponent.setMaximumSize(dimension);
            return dimension;
        }
        return null;
    }

    protected Dimension processPREFERREDSIZE(JComponent jComponent, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("preferredSize", attributeList);
        if (string != null) {
            int n;
            int n2;
            if (string.charAt(0) != '(') {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            int n3 = string.indexOf(",");
            if (n3 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string2 = string.substring(1, n3);
            int n4 = string.indexOf(")", n3);
            if (n4 < 1) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            String string3 = string.substring(n3 + 1, n4);
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            try {
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Size format is (x,y), not: " + string);
            }
            if (this.trace) {
                System.out.println("  PREFERREDSIZE: (" + n2 + "," + n + ")");
            }
            Dimension dimension = new Dimension(n2, n);
            jComponent.setPreferredSize(dimension);
            return dimension;
        }
        return null;
    }

    protected Rectangle processBOUNDS(JComponent jComponent, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("bounds", attributeList);
        if (string != null) {
            int n;
            int n2;
            int n3;
            int n4;
            if (string.charAt(0) != '(') {
                throw new SAXException("Bounds format is (x,y,height,width), not: " + string);
            }
            int n5 = string.indexOf(",");
            if (n5 < 1) {
                throw new SAXException("Bounds format is (x,y,height,width), not: " + string);
            }
            String string2 = string.substring(1, n5);
            int n6 = n5 + 1;
            if ((n5 = string.indexOf(",", n6)) < 1) {
                throw new SAXException("Bounds format is (x,y,height,width), not: " + string);
            }
            String string3 = string.substring(n6, n5);
            n6 = n5 + 1;
            if ((n5 = string.indexOf(",", n6)) < 1) {
                throw new SAXException("Bounds format is (x,y,height,width), not: " + string);
            }
            String string4 = string.substring(n6, n5);
            n6 = n5 + 1;
            int n7 = string.indexOf(")", n6);
            if (n7 < 1) {
                throw new SAXException("Bounds format is (x,y,height,width), not: " + string);
            }
            String string5 = string.substring(n6, n7);
            try {
                n4 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Bad x, bounds format is (x,y,height,width), not: " + string);
            }
            try {
                n3 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Bad y, bounds format is (x,y,height,width), not: " + string);
            }
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Bad width, bounds format is (x,y,height,width), not: " + string);
            }
            try {
                n = Integer.parseInt(string5);
            }
            catch (NumberFormatException numberFormatException) {
                throw new SAXException("Bad  height, bounds format is (x,y,height,width), not: " + string);
            }
            if (this.trace) {
                System.out.println("  BOUNDS: (" + n2 + "," + n + ")");
            }
            Rectangle rectangle = new Rectangle(n4, n3, n2, n);
            jComponent.setBounds(rectangle);
            return rectangle;
        }
        return null;
    }

    protected boolean processOPAQUE(JComponent jComponent, AttributeList attributeList) throws SAXException {
        boolean bl = false;
        String string = this.getAttribute("opaque", attributeList);
        if (string != null) {
            string = string.toLowerCase();
            if (this.trace) {
                System.out.println("  OPAQUE: " + string);
            }
            if (string.equals("true")) {
                bl = true;
            } else if (!string.equals("false")) {
                throw new SAXException("Bad true/false value for opaque: " + string);
            }
            jComponent.setOpaque(bl);
        }
        return bl;
    }

    protected void processAbstractButtonAttributes(AbstractButton abstractButton, AttributeList attributeList) throws SAXException {
        this.processTEXTab(abstractButton, attributeList);
        this.processAbstractButtonICON(abstractButton, attributeList);
        this.processDISABLEDICON(abstractButton, attributeList);
        this.processSELECTED(abstractButton, attributeList);
        this.processENABLED(abstractButton, attributeList);
        this.processMNEMONIC(abstractButton, attributeList);
        this.processBORDERPAINTED(abstractButton, attributeList);
        this.processFOCUSPAINTED(abstractButton, attributeList);
    }

    protected String processTEXTab(AbstractButton abstractButton, AttributeList attributeList) {
        String string = this.getAttribute("text", attributeList);
        if (string != null) {
            if (this.trace) {
                System.out.println("  TEXT: " + string);
            }
            abstractButton.setText(string);
        }
        return string;
    }

    protected void processLAYOUT(Container container, AttributeList attributeList) throws SAXException {
        String string = this.getAttribute("layout", attributeList);
        if (string != null) {
            if (this.trace) {
                System.out.println("  LAYOUT: " + string);
            }
        } else {
            string = "FlowLayout()";
        }
        if (string.equals("null")) {
            container.setLayout(null);
            return;
        }
        if (string.startsWith("BorderLayout(")) {
            Vector vector = this.parseParams(string, 13);
            if (vector.size() == 2) {
                int n = 0;
                int n2 = 0;
                try {
                    n = Integer.parseInt((String)vector.elementAt(0));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n2 = Integer.parseInt((String)vector.elementAt(1));
                }
                catch (NumberFormatException numberFormatException) {}
                container.setLayout(new BorderLayout(n, n2));
                return;
            }
            container.setLayout(new BorderLayout());
            return;
        }
        if (string.startsWith("FlowLayout(")) {
            Vector vector = this.parseParams(string, 11);
            if (vector.size() == 1) {
                int n = 0;
                try {
                    n = Integer.parseInt((String)vector.elementAt(0));
                }
                catch (NumberFormatException numberFormatException) {}
                container.setLayout(new FlowLayout(n));
                return;
            }
            if (vector.size() == 1) {
                int n = 0;
                int n3 = 0;
                int n4 = 0;
                try {
                    n = Integer.parseInt((String)vector.elementAt(0));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n3 = Integer.parseInt((String)vector.elementAt(1));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n4 = Integer.parseInt((String)vector.elementAt(2));
                }
                catch (NumberFormatException numberFormatException) {}
                container.setLayout(new FlowLayout(n, n3, n4));
                return;
            }
            container.setLayout(new FlowLayout());
            return;
        }
        if (string.startsWith("GridLayout(")) {
            Vector vector = this.parseParams(string, 11);
            if (vector.size() == 2) {
                int n = 0;
                int n5 = 0;
                try {
                    n = Integer.parseInt((String)vector.elementAt(0));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n5 = Integer.parseInt((String)vector.elementAt(1));
                }
                catch (NumberFormatException numberFormatException) {}
                container.setLayout(new GridLayout(n, n5));
                return;
            }
            if (vector.size() == 4) {
                int n = 0;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                try {
                    n = Integer.parseInt((String)vector.elementAt(0));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n6 = Integer.parseInt((String)vector.elementAt(1));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n7 = Integer.parseInt((String)vector.elementAt(2));
                }
                catch (NumberFormatException numberFormatException) {}
                try {
                    n8 = Integer.parseInt((String)vector.elementAt(3));
                }
                catch (NumberFormatException numberFormatException) {}
                container.setLayout(new GridLayout(n, n6, n7, n8));
                return;
            }
            container.setLayout(new GridLayout());
            return;
        }
        if (string.startsWith("GridBagLayout(")) {
            container.setLayout(new GridBagLayout());
            return;
        }
        if (string.startsWith("BoxLayout(")) {
            Vector vector = this.parseParams(string, 10);
            int n = 1;
            if (vector.size() != 1) {
                throw new SAXException("Missing parameter for BoxLayout manager '" + string + "'");
            }
            String string2 = ((String)vector.elementAt(0)).toUpperCase();
            if (!string2.equals("X_AXIS") && !string2.equals("Y_AXIS")) {
                throw new SAXException("Bad parameter for BoxLayout manager '" + string + "'");
            }
            container.setLayout(new BoxLayout(container, n));
            return;
        }
        throw new SAXException("Cannot created layout manager '" + string + "'");
    }

    protected void addConstrained(Container container, Component component, AttributeList attributeList) {
        String string = this.getAttribute("constraint", attributeList);
        if (string == null) {
            container.add(component);
            return;
        }
        container.add(component, string);
    }

    protected void addConstrained(Container container, Component component, String string) {
        if (string == null) {
            container.add(component);
            return;
        }
        container.add(component, string);
    }

    protected Vector parseParams(String string, int n) {
        String string2;
        Vector<String> vector = new Vector<String>();
        int n2 = string.indexOf(",", n);
        while (n2 != -1) {
            string2 = string.substring(n, n2);
            vector.addElement(string2);
            n = n2 + 1;
            n2 = string.indexOf(",", n);
        }
        n2 = string.indexOf(")", n);
        if (n2 != -1) {
            string2 = string.substring(n, n2);
            vector.addElement(string2);
        }
        return vector;
    }

    protected String saveScript(Component component, AttributeList attributeList) {
        String string = this.getAttribute("script", attributeList);
        if (string != null && this.trace) {
            System.out.println("  SCRIPT: " + string);
        }
        return string;
    }

    protected void processScript(Component component, String string) throws SAXException {
        if (string != null) {
            if (this.trace) {
                System.out.println("  Processing SCRIPT");
            }
            try {
                JSObject jSObject = this.guiContext.global.makeObjectWrapper((Object)component);
                jSObject.eval(string);
                return;
            }
            catch (JSException jSException) {
                throw new SAXException("Cannot evaluate script: " + jSException.getMessage(), (Exception)((Object)jSException));
            }
        }
    }

    float componentAlignmentByName(String string) throws SAXException {
        String string2 = string.toLowerCase();
        if (string2.equals("bottom")) {
            return 1.0f;
        }
        if (string2.equals("center")) {
            return 0.5f;
        }
        if (string2.equals("left")) {
            return 0.0f;
        }
        if (string2.equals("rigth")) {
            return 1.0f;
        }
        if (string2.equals("top")) {
            return 0.0f;
        }
        throw new SAXException("Unrecognized alignment: " + string);
    }

    int jTextFieldAlignmentByName(String string) throws SAXException {
        String string2 = string.toLowerCase();
        if (string2.equals("left")) {
            return 2;
        }
        if (string2.equals("center")) {
            return 0;
        }
        if (string2.equals("right")) {
            return 4;
        }
        throw new SAXException("Unrecognized alignment: " + string);
    }

    int styleByName(String string) throws SAXException {
        String string2 = string.toLowerCase();
        if (string2.equals("bold")) {
            return 1;
        }
        if (string2.equals("italic")) {
            return 2;
        }
        if (string2.equals("plain")) {
            return 0;
        }
        throw new SAXException("Urecognized style: " + string);
    }

    Color colorByName(String string) throws SAXException {
        String string2 = string.toLowerCase();
        if (string2.equals("black")) {
            return Color.black;
        }
        if (string2.equals("blue")) {
            return Color.blue;
        }
        if (string2.equals("cyan")) {
            return Color.cyan;
        }
        if (string2.equals("darkgray")) {
            return Color.darkGray;
        }
        if (string2.equals("gray")) {
            return Color.gray;
        }
        if (string2.equals("green")) {
            return Color.green;
        }
        if (string2.equals("lightgray")) {
            return Color.lightGray;
        }
        if (string2.equals("magenta")) {
            return Color.magenta;
        }
        if (string2.equals("orange")) {
            return Color.orange;
        }
        if (string2.equals("pink")) {
            return Color.pink;
        }
        if (string2.equals("red")) {
            return Color.red;
        }
        if (string2.equals("white")) {
            return Color.white;
        }
        if (string2.equals("yellow")) {
            return Color.yellow;
        }
        throw new SAXException("Unrecognized color: " + string);
    }

    Component createComponent(Class clazz, AttributeList attributeList) throws SAXException {
        Component component;
        String string = this.getAttribute("creationScript", attributeList);
        if (string == null) {
            Object t;
            try {
                t = clazz.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SAXException("Not allowed to create a " + clazz, illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new SAXException("Not allowed to create a " + clazz, instantiationException);
            }
            if (!clazz.isInstance(t)) {
                throw new SAXException(String.valueOf(clazz) + " is not a Component");
            }
            component = (Component)t;
        } else {
            Object object;
            try {
                object = this.guiContext.global.evalAsFunction(string);
            }
            catch (JSException jSException) {
                throw new SAXException("Cannot evaluate CreationScript: " + jSException.getMessage(), (Exception)((Object)jSException));
            }
            if (!clazz.isInstance(object)) {
                throw new SAXException("creationScript did not return a " + clazz);
            }
            component = (Component)object;
        }
        return component;
    }

    private static final class 1
    implements MouseListener {
        private final /* synthetic */ JPopupMenu val$popupMenu;

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.val$popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.val$popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.val$popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        /* synthetic */ 1(JPopupMenu jPopupMenu) {
            this.val$popupMenu = jPopupMenu;
        }
    }
}

