/*
 * Decompiled with CFR 0.152.
 */
package FesiForm;

import FESI.jslib.JSException;
import FESI.jslib.JSObject;
import FesiForm.DefaultDocumentHandler;
import FesiForm.GuiContext;
import FesiForm.JDialogDocumentHandler;
import FesiForm.JFrameDocumentHandler;
import FesiForm.JPopupMenuDocumentHandler;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class GuiDocumentHandler
extends DefaultDocumentHandler {
    private boolean inScript = false;
    private boolean startScriptSeen = false;
    private boolean endScriptSeen = false;
    private boolean endSeen = false;
    private StringBuffer currentScript;
    private String containedName;

    public GuiDocumentHandler(GuiContext guiContext, boolean bl) {
        super(guiContext, bl);
    }

    public void startDocument() throws SAXException {
        if (this.trace) {
            System.out.println("GUI START_DOCUMENT");
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.trace) {
            System.out.println("GUI START_ELEMENT: <" + string + ">, " + attributeList.getLength() + " attribute(s)");
        }
        if (string.equals("script")) {
            if (this.endSeen || this.endScriptSeen) {
                throw new SAXException("SCRIPT after end ignored");
            }
            this.currentScript = null;
            this.inScript = true;
            if (this.startScriptSeen) {
                this.endScriptSeen = true;
                return;
            }
            this.startScriptSeen = true;
            return;
        }
        if (string.equals("JFrame")) {
            if (this.endScriptSeen) {
                throw new SAXException("JFRAME after end or end script ignored");
            }
            this.containedName = string;
            JFrameDocumentHandler jFrameDocumentHandler = new JFrameDocumentHandler("JFrame", this, this.guiContext, this.trace);
            this.guiContext.parser.setDocumentHandler(jFrameDocumentHandler);
            jFrameDocumentHandler.startElement(string, attributeList);
            return;
        }
        if (string.equals("JDialog")) {
            if (this.endScriptSeen) {
                throw new SAXException("JDIALOG after end or end script ignored");
            }
            this.containedName = string;
            JDialogDocumentHandler jDialogDocumentHandler = new JDialogDocumentHandler("JDialog", this, this.guiContext, this.trace);
            this.guiContext.parser.setDocumentHandler(jDialogDocumentHandler);
            jDialogDocumentHandler.startElement(string, attributeList);
            return;
        }
        if (string.equals("JPopupMenu")) {
            if (this.endScriptSeen) {
                throw new SAXException("JPOPUPMENU after end or end script ignored");
            }
            this.containedName = string;
            JPopupMenuDocumentHandler jPopupMenuDocumentHandler = new JPopupMenuDocumentHandler("JPopupMenu", this, this.guiContext, this.trace);
            this.guiContext.parser.setDocumentHandler(jPopupMenuDocumentHandler);
            jPopupMenuDocumentHandler.startElement(string, attributeList);
            return;
        }
        if (string.equals("gui")) {
            String string2 = this.getAttribute("lf", attributeList);
            if (string2 != null && string2.equalsIgnoreCase("native")) {
                this.guiContext.useNative = true;
                return;
            }
        } else {
            throw new SAXException("Unexpected GUI ELEMENT: " + string);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.trace) {
            System.out.println("GUI CHARACTERS: [[" + new String(cArray) + "]]");
        }
        if (this.inScript) {
            if (this.currentScript == null) {
                this.currentScript = new StringBuffer(n2);
            }
            this.currentScript.append(cArray, n, n2);
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.trace) {
            System.out.println("GUI END_ELEMENT: </" + string + ">");
        }
        if (string.equals("script")) {
            if (this.currentScript != null) {
                String string2 = this.currentScript.toString();
                this.currentScript = null;
                this.inScript = false;
                if (this.trace) {
                    System.out.println("  SCRIPT: " + string2);
                }
                try {
                    JSObject jSObject = this.guiContext.global.makeObjectWrapper((Object)this.guiContext);
                    jSObject.eval(string2.toString());
                    return;
                }
                catch (JSException jSException) {
                    throw new SAXException("Cannot evaluate script: " + jSException.getMessage(), (Exception)((Object)jSException));
                }
            }
        } else {
            if (string.equals("gui")) {
                this.endScriptSeen = true;
                this.endSeen = true;
                return;
            }
            if (string.equals(this.containedName)) {
                this.containedName = null;
                this.guiContext.parser.setDocumentHandler(this);
                return;
            }
            throw new SAXException("Unexpected GUI ELEMENT end: " + string);
        }
    }

    public void endDocument() {
        if (this.trace) {
            System.out.println("GUI END_DOCUMENT");
        }
    }
}

