/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESPrimitive;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Interpreter.Evaluator;
import FESI.Interpreter.ScopeChain;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public class ArrayPrototype
extends ESObject {
    private static final String LENGTHstring = "length".intern();
    private static final int LENGTHhash = LENGTHstring.hashCode();
    protected Vector theArray = new Vector();

    public ArrayPrototype(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator);
    }

    public String getESClassName() {
        return "Array";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object toJavaArray(Class clazz) throws EcmaScriptException {
        int n = this.size();
        Object object = Array.newInstance(clazz, n);
        if (n == 0) {
            return object;
        }
        int n2 = 0;
        while (n2 < n) {
            ESValue eSValue = (ESValue)this.theArray.elementAt(n2);
            if (clazz == Integer.TYPE) {
                if (!eSValue.isNumberValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                double d = eSValue.doubleValue();
                int n3 = (int)d;
                if ((double)n3 != d) {
                    throw new EcmaScriptException("An element (" + eSValue + ") of array is too large for class " + clazz);
                }
                Array.setInt(object, n2, n3);
            } else if (clazz == Short.TYPE) {
                if (!eSValue.isNumberValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                double d = eSValue.doubleValue();
                short s = (short)d;
                if ((double)s != d) {
                    throw new EcmaScriptException("An element (" + eSValue + ") of array is too large for class " + clazz);
                }
                Array.setShort(object, n2, s);
            } else if (clazz == Byte.TYPE) {
                if (!eSValue.isNumberValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                double d = eSValue.doubleValue();
                byte by = (byte)d;
                if ((double)by != d) {
                    throw new EcmaScriptException("An element (" + eSValue + ") of array is too large for class " + clazz);
                }
                Array.setByte(object, n2, by);
            } else if (clazz == Long.TYPE) {
                if (!eSValue.isNumberValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                double d = eSValue.doubleValue();
                long l = (long)d;
                if ((double)l != d) {
                    throw new EcmaScriptException("An element (" + eSValue + ") of array is too large for class " + clazz);
                }
                Array.setLong(object, n2, l);
            } else if (clazz == Float.TYPE) {
                if (!eSValue.isNumberValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                double d = eSValue.doubleValue();
                float f = (float)d;
                if ((double)f != d) {
                    throw new EcmaScriptException("An element (" + eSValue + ") of array is too large for class " + clazz);
                }
                Array.setFloat(object, n2, f);
            } else if (clazz == Double.TYPE) {
                if (!eSValue.isNumberValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                double d = eSValue.doubleValue();
                Array.setDouble(object, n2, d);
            } else if (clazz == Boolean.TYPE) {
                if (!eSValue.isBooleanValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                boolean bl = eSValue.booleanValue();
                Array.setBoolean(object, n2, bl);
            } else if (clazz == Character.TYPE) {
                if (!eSValue.isStringValue()) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                String string = eSValue.toString();
                if (string.length() != 1) {
                    throw new EcmaScriptException("A string (" + eSValue + ") of array is not of size 1 for conversion to Character");
                }
                Array.setChar(object, n2, string.charAt(0));
            } else {
                Object object2 = eSValue.toJavaObject();
                if (object2 == null) {
                    Array.set(object, n2, object2);
                } else {
                    Class<?> clazz2 = object2.getClass();
                    if (!clazz.isAssignableFrom(clazz2)) throw new EcmaScriptException("An element (" + eSValue + ") of array cannot be converted to class " + clazz);
                    Array.set(object, n2, object2);
                }
            }
            ++n2;
        }
        return object;
    }

    public String toDetailString() {
        return "ES:[" + this.getESClassName() + ":" + this.getClass().getName() + "]";
    }

    public int size() {
        return this.theArray.size();
    }

    public void setSize(int n) {
        this.theArray.setSize(n);
    }

    public void setElementAt(ESValue eSValue, int n) {
        this.theArray.setElementAt(eSValue, n);
    }

    public ESValue reverse() throws EcmaScriptException {
        int n = this.theArray.size();
        if (n > 0) {
            Vector vector = new Vector(n);
            vector.setSize(n);
            int n2 = 0;
            int n3 = n - 1;
            while (n2 < n) {
                vector.setElementAt(this.theArray.elementAt(n3), n2);
                ++n2;
                --n3;
            }
            this.theArray = vector;
        }
        return this;
    }

    private void sort(int n, int n2, Comparer comparer) throws EcmaScriptException {
        if (this.theArray.size() < 2) {
            return;
        }
        int n3 = n;
        int n4 = n2;
        ESValue eSValue = (ESValue)this.theArray.elementAt((n + n2) / 2);
        do {
            ESValue eSValue2 = (ESValue)this.theArray.elementAt(n3);
            ESValue eSValue3 = (ESValue)this.theArray.elementAt(n4);
            while (n3 < n2 && comparer.compare(eSValue, eSValue2) > 0) {
                eSValue2 = (ESValue)this.theArray.elementAt(++n3);
            }
            while (n4 > n && comparer.compare(eSValue, eSValue3) < 0) {
                eSValue3 = (ESValue)this.theArray.elementAt(--n4);
            }
            if (n3 < n4) {
                ESValue eSValue4 = eSValue2;
                this.theArray.setElementAt(eSValue3, n3);
                this.theArray.setElementAt(eSValue4, n4);
            }
            if (n3 > n4) continue;
            ++n3;
            --n4;
        } while (n3 <= n4);
        if (n < n4) {
            this.sort(n, n4, comparer);
        }
        if (n3 < n2) {
            this.sort(n3, n2, comparer);
        }
    }

    public ESValue sort(ESValue eSValue) throws EcmaScriptException {
        if (eSValue != null && !(eSValue instanceof FunctionPrototype)) {
            throw new EcmaScriptException("Compare function not a function: " + eSValue);
        }
        Comparer comparer = null;
        comparer = eSValue != null ? new FunctionComparer((FunctionPrototype)eSValue) : new DefaultComparer();
        this.sort(0, this.theArray.size() - 1, comparer);
        return this;
    }

    public void putProperty(String string, ESValue eSValue, int n) throws EcmaScriptException {
        if (n == LENGTHhash && string.equals(LENGTHstring)) {
            int n2 = (int)((ESPrimitive)eSValue).doubleValue();
            if (n2 < 0) {
                throw new EcmaScriptException("Invalid length value: " + eSValue);
            }
            this.theArray.setSize(n2);
            return;
        }
        int n3 = -1;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n3 < 0) {
            super.putProperty(string, eSValue, n);
            return;
        }
        this.putProperty(n3, eSValue);
    }

    public void putProperty(int n, ESValue eSValue) throws EcmaScriptException {
        if (n >= this.theArray.size()) {
            this.theArray.setSize(n + 1);
        }
        this.theArray.setElementAt(eSValue, n);
    }

    public ESValue getPropertyInScope(String string, ScopeChain scopeChain, int n) throws EcmaScriptException {
        if (n == LENGTHhash && string.equals(LENGTHstring)) {
            return new ESNumber(this.theArray.size());
        }
        if (this.hasProperty(string, n)) {
            return this.getProperty(string, n);
        }
        if (scopeChain == null) {
            throw new EcmaScriptException("global variable '" + string + "' does not have a value");
        }
        return scopeChain.getValue(string, n);
    }

    public ESValue getProperty(String string, int n) throws EcmaScriptException {
        if (n == LENGTHhash && string.equals(LENGTHstring)) {
            return new ESNumber(this.theArray.size());
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n2 < 0) {
            return super.getProperty(string, n);
        }
        return this.getProperty(n2);
    }

    public ESValue getProperty(int n) throws EcmaScriptException {
        Object var2_2 = null;
        if (n < this.theArray.size()) {
            var2_2 = this.theArray.elementAt(n);
        }
        if (var2_2 == null) {
            return ESUndefined.theUndefined;
        }
        return var2_2;
    }

    public boolean hasProperty(String string, int n) throws EcmaScriptException {
        if (n == LENGTHhash && string.equals(LENGTHstring)) {
            return true;
        }
        int n2 = -1;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {}
        if (n2 < 0) {
            return super.hasProperty(string, n);
        }
        return n2 < this.theArray.size();
    }

    public Enumeration getProperties() {
        return new 1();
    }

    public Enumeration getAllProperties() {
        return new 2();
    }

    public String[] getSpecialPropertyNames() {
        String[] stringArray = new String[]{LENGTHstring};
        return stringArray;
    }

    static interface Comparer {
        public int compare(ESValue var1, ESValue var2) throws EcmaScriptException;
    }

    static class DefaultComparer
    implements Comparer {
        public int compare(ESValue eSValue, ESValue eSValue2) throws EcmaScriptException {
            ESValue eSValue3 = eSValue.toESPrimitive(4);
            ESValue eSValue4 = eSValue2.toESPrimitive(4);
            if (eSValue3 == ESUndefined.theUndefined && eSValue4 == ESUndefined.theUndefined) {
                return 0;
            }
            if (eSValue3 == ESUndefined.theUndefined) {
                return 1;
            }
            if (eSValue4 == ESUndefined.theUndefined) {
                return -1;
            }
            String string = eSValue.toString();
            String string2 = eSValue2.toString();
            return string.compareTo(string2);
        }

        DefaultComparer() {
        }
    }

    private final class 1
    implements Enumeration {
        Enumeration props;
        Object currentKey;
        int currentHash;
        int nextIndex;
        boolean inside;
        ESObject prototype;

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.currentKey == null) ** GOTO lbl4
            return true;
lbl-1000:
            // 1 sources

            {
                ++this.nextIndex;
lbl4:
                // 2 sources

                ** while (this.nextIndex < ArrayPrototype.this.theArray.size() && ArrayPrototype.this.theArray.elementAt((int)this.nextIndex) == null)
            }
lbl5:
            // 1 sources

            if (this.nextIndex >= ArrayPrototype.this.theArray.size()) ** GOTO lbl12
            this.currentKey = new ESNumber(this.nextIndex++);
            return true;
lbl-1000:
            // 1 sources

            {
                this.currentKey = this.props.nextElement();
                this.currentHash = this.currentKey.hashCode();
                if (this.inside != false ? ArrayPrototype.this.properties.containsKey((String)this.currentKey, this.currentHash) != false : ArrayPrototype.this.isHiddenProperty((String)this.currentKey, this.currentHash) != false) continue;
                return true;
lbl12:
                // 2 sources

                ** while (this.props.hasMoreElements())
            }
lbl13:
            // 1 sources

            if (!this.inside && this.prototype != null) {
                this.inside = true;
                this.props = this.prototype.getProperties();
                while (this.props.hasMoreElements()) {
                    this.currentKey = this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (ArrayPrototype.this.properties.containsKey((String)this.currentKey, this.currentHash)) continue;
                    return true;
                }
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                Object object = this.currentKey;
                this.currentKey = null;
                return object;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 1() {
            this.props = ArrayPrototype.this.properties.keys();
            this.inside = false;
            this.prototype = ArrayPrototype.this.getPrototype();
        }
    }

    private final class 2
    implements Enumeration {
        String[] specialProperties;
        int specialEnumerator;
        Enumeration props;
        String currentKey;
        int currentHash;
        boolean inside;
        int nextIndex;

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.currentKey != null) {
                return true;
            }
            if (this.nextIndex < ArrayPrototype.this.theArray.size()) {
                while (this.nextIndex < ArrayPrototype.this.theArray.size() && ArrayPrototype.this.theArray.elementAt(this.nextIndex) == null) {
                    ++this.nextIndex;
                }
                if (this.nextIndex < ArrayPrototype.this.theArray.size()) {
                    this.currentKey = Integer.toString(this.nextIndex);
                    this.currentHash = this.currentKey.hashCode();
                    ++this.nextIndex;
                    return true;
                }
            }
            if (this.specialEnumerator >= this.specialProperties.length) ** GOTO lbl21
            this.currentKey = this.specialProperties[this.specialEnumerator];
            this.currentHash = this.currentKey.hashCode();
            ++this.specialEnumerator;
            return true;
lbl-1000:
            // 1 sources

            {
                this.currentKey = (String)this.props.nextElement();
                this.currentHash = this.currentKey.hashCode();
                if (this.inside && ArrayPrototype.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                return true;
lbl21:
                // 2 sources

                ** while (this.props.hasMoreElements())
            }
lbl22:
            // 1 sources

            if (!this.inside && ArrayPrototype.this.getPrototype() != null) {
                this.inside = true;
                this.props = ArrayPrototype.this.getPrototype().getProperties();
                while (this.props.hasMoreElements()) {
                    this.currentKey = (String)this.props.nextElement();
                    this.currentHash = this.currentKey.hashCode();
                    if (ArrayPrototype.this.properties.containsKey(this.currentKey, this.currentHash)) continue;
                    return true;
                }
            }
            return false;
        }

        public Object nextElement() {
            if (this.hasMoreElements()) {
                String string = this.currentKey;
                this.currentKey = null;
                return string;
            }
            throw new NoSuchElementException();
        }

        /* synthetic */ 2() {
            this.specialProperties = ArrayPrototype.this.getSpecialPropertyNames();
            this.props = ArrayPrototype.this.properties.keys();
            this.inside = false;
        }
    }

    class FunctionComparer
    implements Comparer {
        FunctionPrototype compareFn;
        ESValue[] arguments;
        ESObject thisObject;

        public FunctionComparer(FunctionPrototype functionPrototype) {
            ArrayPrototype.this = ArrayPrototype.this;
            this.compareFn = functionPrototype;
            this.arguments = new ESValue[2];
            this.thisObject = ArrayPrototype.this.evaluator.getGlobalObject();
        }

        public int compare(ESValue eSValue, ESValue eSValue2) throws EcmaScriptException {
            ESValue eSValue3 = eSValue.toESPrimitive(4);
            ESValue eSValue4 = eSValue2.toESPrimitive(4);
            if (eSValue3 == ESUndefined.theUndefined && eSValue4 == ESUndefined.theUndefined) {
                return 0;
            }
            if (eSValue3 == ESUndefined.theUndefined) {
                return 1;
            }
            if (eSValue4 == ESUndefined.theUndefined) {
                return -1;
            }
            this.arguments[0] = eSValue;
            this.arguments[1] = eSValue2;
            ESValue eSValue5 = this.compareFn.callFunction(this.thisObject, this.arguments);
            return eSValue5.toInt32();
        }
    }
}

