/*
 * Decompiled with CFR 0.152.
 */
package FESI.Data;

import FESI.Data.BooleanObject;
import FESI.Data.BooleanPrototype;
import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESBoolean;
import FESI.Data.ESNumber;
import FESI.Data.ESObject;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Exceptions.ProgrammingError;
import FESI.Interpreter.Evaluator;

public class BooleanObject
extends BuiltinFunctionObject {
    private BooleanObject(ESObject eSObject, Evaluator evaluator) {
        super(eSObject, evaluator, "Boolean", 1);
    }

    public String toString() {
        return "<Boolean>";
    }

    public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        if (eSValueArray.length == 0) {
            return ESBoolean.makeBoolean(false);
        }
        return ESBoolean.makeBoolean(eSValueArray[0].booleanValue());
    }

    public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
        BooleanPrototype booleanPrototype = null;
        ESObject eSObject2 = this.evaluator.getBooleanPrototype();
        booleanPrototype = new BooleanPrototype(eSObject2, this.evaluator);
        booleanPrototype.value = eSValueArray.length > 0 ? ESBoolean.makeBoolean(eSValueArray[0].booleanValue()) : ESBoolean.makeBoolean(false);
        return booleanPrototype;
    }

    public static BooleanObject makeBooleanObject(Evaluator evaluator, ObjectPrototype objectPrototype, FunctionPrototype functionPrototype) {
        BooleanPrototype booleanPrototype = new BooleanPrototype(objectPrototype, evaluator);
        BooleanObject booleanObject = new BooleanObject(functionPrototype, evaluator);
        try {
            booleanObject.putHiddenProperty("prototype", booleanPrototype);
            booleanObject.putHiddenProperty("length", new ESNumber(1.0));
            booleanPrototype.putHiddenProperty("constructor", booleanObject);
            booleanPrototype.putHiddenProperty("toString", new 1.BooleanPrototypeToString("toString", evaluator, functionPrototype));
            booleanPrototype.putHiddenProperty("valueOf", new 1.BooleanPrototypeValueOf("valueOf", evaluator, functionPrototype));
        }
        catch (EcmaScriptException ecmaScriptException) {
            ecmaScriptException.printStackTrace();
            throw new ProgrammingError(ecmaScriptException.getMessage());
        }
        evaluator.setBooleanPrototype(booleanPrototype);
        return booleanObject;
    }
}

