/*
 * Decompiled with CFR 0.152.
 */
package FESI.Interpreter;

import FESI.Data.ESLoader;
import FESI.Exceptions.EcmaScriptException;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class LocalClassLoader
extends ClassLoader {
    public static final String urlPrefix = "FESI";
    public static final String resourceName = "fesiresource";
    private static Hashtable loadersByCookie = new Hashtable();
    private static Hashtable loadersByFilename = new Hashtable();
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    private static int cookieCount = 1;
    private static char fileSep = System.getProperty("file.separator", "/").charAt(0);
    private boolean asJar;
    private String myCookie;
    private ZipFile zipFile;
    private File directoryFile;

    private LocalClassLoader(File file) {
        this.directoryFile = file;
        this.asJar = false;
        this.myCookie = "fcl" + cookieCount++;
        loadersByCookie.put(this.myCookie, this);
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** New class loader: " + this);
        }
    }

    private LocalClassLoader(ZipFile zipFile) {
        this.asJar = true;
        this.zipFile = zipFile;
        this.myCookie = "fcl" + cookieCount++;
        loadersByCookie.put(this.myCookie, this);
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** New class loader: " + this);
        }
    }

    public static synchronized LocalClassLoader makeLocalClassLoader(String string) throws EcmaScriptException {
        LocalClassLoader localClassLoader = null;
        File file = new File(string);
        String string2 = null;
        if (file.isFile()) {
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            localClassLoader = (LocalClassLoader)loadersByFilename.get(string2);
            if (localClassLoader == null) {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(string2);
                }
                catch (IOException iOException) {
                    throw new EcmaScriptException("IO Error opening zip file '" + string2 + "' : " + iOException);
                }
                localClassLoader = new LocalClassLoader(zipFile);
                loadersByFilename.put(string2, localClassLoader);
            } else if (ESLoader.isDebugLoader()) {
                System.out.println(" ** loader in cache: " + localClassLoader);
            }
        } else if (file.isDirectory()) {
            try {
                string2 = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            localClassLoader = (LocalClassLoader)loadersByFilename.get(string2);
            if (localClassLoader == null) {
                localClassLoader = new LocalClassLoader(file);
                loadersByFilename.put(string2, localClassLoader);
            } else if (ESLoader.isDebugLoader()) {
                System.out.println(" ** loader in cache: " + localClassLoader);
            }
        } else {
            throw new EcmaScriptException("No file or directory '" + string + "' found");
        }
        return localClassLoader;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, true);
    }

    public Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        try {
            Class<?> clazz = this.findLoadedClass(string);
            if (clazz == null) {
                try {
                    clazz = this.findSystemClass(string);
                }
                catch (Exception exception) {}
            }
            if (clazz == null) {
                String string2 = String.valueOf(string.replace('.', this.asJar ? (char)'/' : (char)fileSep)) + ".class";
                byte[] byArray = this.getResourceBuffer(string2);
                if (byArray == null) {
                    if (ESLoader.isDebugLoader()) {
                        System.out.println(" ** class '" + string + "' not loaded");
                    }
                    throw new ClassNotFoundException("Class '" + string + "' not foud by " + this);
                }
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** class '" + string + "' loaded");
                }
                clazz = this.defineClass(string, byArray, 0, byArray.length);
            }
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        catch (Exception exception) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** Error loading '" + string + "' by loader: " + this + ", " + exception);
            }
            throw new ClassNotFoundException(exception.toString());
        }
    }

    public URL getResource(String string) {
        URL uRL;
        block6: {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** getResource: '" + string + "' asked to: " + this);
            }
            if ((uRL = ClassLoader.getSystemResource(string)) != null) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** URL found in system as: " + uRL);
                }
                return uRL;
            }
            try {
                uRL = new URL(resourceName, null, "/FESI" + this.myCookie + "/+/" + string);
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** URL found as " + uRL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                if (!ESLoader.isDebugLoader()) break block6;
                System.out.println(" ** Bad URL " + uRL + " " + malformedURLException);
            }
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** getResourceAsStream: '" + string + "' asked to: " + this);
        }
        if ((inputStream = ClassLoader.getSystemResourceAsStream(string)) != null) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** getResourceAsStream(" + string + ") is a system resource");
            }
            return inputStream;
        }
        return this.getLocalResourceAsStream(string);
    }

    private byte[] getResourceBuffer(String string) {
        byte[] byArray = null;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** getResourceBuffer, resource '" + string + "'");
        }
        if (this.asJar) {
            ZipEntry zipEntry = this.zipFile.getEntry(string);
            if (zipEntry == null) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Resource '" + string + "'not found in jar by: " + this);
                }
                return null;
            }
            try {
                int n;
                InputStream inputStream = this.zipFile.getInputStream(zipEntry);
                int n2 = (int)zipEntry.getSize();
                byArray = new byte[n2];
                for (int i = 0; i < n2; i += n) {
                    n = inputStream.read(byArray, i, n2 - i);
                    if (n != 0) continue;
                    if (ESLoader.isDebugLoader()) {
                        System.out.println(" ** Error read entry '" + string + "' in jar, loader: " + this);
                        System.out.println("Only " + i + " bytes out of " + n2 + " read from entry '" + string + "' in jar '" + this.zipFile.getName() + "'");
                    }
                    throw new IOException("Only " + i + " bytes out of " + n2 + " read from entry '" + string + "' in jar '" + this.zipFile.getName() + "'");
                }
                inputStream.close();
            }
            catch (IOException iOException) {
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Error reading jar: " + iOException);
                }
                return null;
            }
        }
        try {
            File file = new File(this.directoryFile, string);
            int n = (int)file.length();
            byArray = new byte[n];
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(file));
            dataInputStream.readFully(byArray);
            dataInputStream.close();
        }
        catch (IOException iOException) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** Error reading file: " + iOException);
            }
            return null;
        }
        return byArray;
    }

    private Object getLocalResource(String string) {
        byte[] byArray;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** getLocalResource, resource '" + string + "' asked to: " + this);
        }
        if ((byArray = this.getResourceBuffer(string)) == null) {
            return null;
        }
        if (string.endsWith(".gif") || string.endsWith(".jpeg")) {
            Image image = Toolkit.getDefaultToolkit().createImage(byArray);
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** Returning image resource: " + image);
            }
            return image;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Returning stream resource: " + byteArrayInputStream);
        }
        return byteArrayInputStream;
    }

    private InputStream getLocalResourceAsStream(String string) {
        block11: {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" ** getLocalResourceAsStream,  resource '" + string + "' asked to: " + this);
            }
            if (this.asJar) {
                try {
                    ZipEntry zipEntry = this.zipFile.getEntry(string);
                    if (zipEntry != null) {
                        InputStream inputStream = this.zipFile.getInputStream(zipEntry);
                        if (ESLoader.isDebugLoader()) {
                            System.out.println(" ** Resource found, returned as stream: " + inputStream);
                        }
                        return inputStream;
                    }
                    break block11;
                }
                catch (Exception exception) {
                    if (ESLoader.isDebugLoader()) {
                        System.out.println(" ** Exception when loading resource: " + string + ": " + exception);
                    }
                    break block11;
                }
            }
            File file = new File(this.directoryFile, string);
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                if (ESLoader.isDebugLoader()) {
                    System.out.println(" ** Resource found, returned as stream: " + fileInputStream);
                }
                return fileInputStream;
            }
            catch (IOException iOException) {
                if (!ESLoader.isDebugLoader()) break block11;
                System.out.println(" ** Exception when loading resource: " + string + ": " + iOException);
            }
        }
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Resource not found: " + string);
        }
        return null;
    }

    public static InputStream getLocalResourceAsStream(String string, String string2) {
        LocalClassLoader localClassLoader;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** static getLocalResourceAsStream, cookie: " + string + ", resource: " + string2);
        }
        if ((localClassLoader = (LocalClassLoader)loadersByCookie.get(string)) == null) {
            if (ESLoader.isDebugLoader()) {
                System.err.println(" @@ LocalClassLoader cookie: " + string + " NOT FOUND !");
            }
            return null;
        }
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Classloader found: " + localClassLoader);
        }
        return localClassLoader.getLocalResourceAsStream(string2);
    }

    public static Object getLocalResource(String string, String string2) {
        LocalClassLoader localClassLoader;
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** static getLocalResource, cookie: " + string + ", resource: " + string2);
        }
        if ((localClassLoader = (LocalClassLoader)loadersByCookie.get(string)) == null) {
            if (ESLoader.isDebugLoader()) {
                System.out.println(" @@ LocalClassLoader cookie: " + string + " NOT FOUND !");
            }
            return null;
        }
        if (ESLoader.isDebugLoader()) {
            System.out.println(" ** Classloader found: " + localClassLoader);
        }
        return localClassLoader.getLocalResource(string2);
    }

    public String toString() {
        return "LocalClassLoader[" + this.myCookie + "]:" + (this.asJar ? "JAR='" + this.zipFile.getName() : "DIR='" + this.directoryFile) + "'";
    }

    static {
        Properties properties = new Properties(System.getProperties());
        ((Hashtable)properties).put(protocolPathProp, String.valueOf(properties.getProperty(protocolPathProp)) + "|FESI.Interpreter");
        System.setProperties(properties);
    }
}

