/*
 * Decompiled with CFR 0.152.
 */
package FESI.awtgui;

import FESI.Exceptions.ProgrammingError;
import FESI.gui.Console;
import FESI.gui.InterpreterCommands;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;

public class AwtConsole
extends Frame
implements Console {
    private static String eol = System.getProperty("line.separator", "\n");
    private TextArea theTextArea;
    private static InputStream consoleIn;
    private static PrintStream consoleOut;
    private static InterpreterCommands itrp;
    static boolean initialized;
    static boolean needsAppend;

    public InputStream getConsoleIn() {
        return consoleIn;
    }

    public PrintStream getConsoleOut() {
        return consoleOut;
    }

    public AwtConsole(InterpreterCommands interpreterCommands, String string, int n, int n2) {
        super(string);
        itrp = interpreterCommands;
        this.theTextArea = new TextArea(n, n2);
        this.theTextArea.setFont(new Font("monospaced", 0, 12));
        ((Component)this.theTextArea).setBackground(Color.lightGray);
        this.add(this.theTextArea);
        this.theTextArea.setVisible(true);
        this.pack();
        int n3 = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n4 = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n5 = this.getSize().width;
        int n6 = this.getSize().height;
        ((Component)this).setLocation((n3 - n5) / 2, (n4 - n6) / 2);
        consoleIn = new LineInputStream(new TextAreaInputStream(this.theTextArea));
        consoleOut = new PrintStream(new TextAreaOutputStream(this.theTextArea), true);
        System.setOut(consoleOut);
        System.setIn(consoleIn);
        System.setErr(consoleOut);
        this.addWindowListener(new 1());
        this.show();
    }

    public synchronized void clear() {
        this.theTextArea.setText("");
    }

    public boolean supportsEditing() {
        return false;
    }

    public void createEditor(String string) {
        throw new ProgrammingError("Create editor called in non supported environment");
    }

    public void displayAbout() {
        itrp.displayAboutText();
    }

    public void displayHelpText() {
        itrp.displayHelpText();
    }

    public void displayHelpWindow() {
    }

    static boolean needsAppend() {
        block2: {
            if (initialized) break block2;
            initialized = true;
            try {
                String string = System.getProperty("awt.toolkit", "");
                needsAppend = string == null || string.indexOf("com.ms") < 0;
            }
            catch (SecurityException securityException) {}
        }
        return needsAppend;
    }

    static {
        itrp = null;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            itrp.exit();
        }

        /* synthetic */ 1() {
        }
    }

    public class LineInputStream
    extends FilterInputStream {
        byte[] byteArray;
        int arrayOffset;
        int arrayLength;

        public LineInputStream(InputStream inputStream) {
            super(inputStream);
            AwtConsole.this = AwtConsole.this;
        }

        public synchronized int read() throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                return this.byteArray[this.arrayOffset++];
            }
            return -1;
        }

        public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.byteArray != null && this.arrayOffset < this.arrayLength) {
                int n3 = this.available();
                if (n2 > n3) {
                    n2 = n3;
                }
                System.arraycopy(this.byteArray, this.arrayOffset, byArray, n, n2);
                this.arrayOffset += n2;
                return n2;
            }
            this.byteArray = this.readLine();
            this.arrayOffset = 0;
            this.arrayLength = this.byteArray.length;
            if (this.byteArray == null || this.arrayOffset >= this.arrayLength) {
                return -1;
            }
            int n4 = this.available();
            if (n2 > n4) {
                n2 = n4;
            }
            System.arraycopy(this.byteArray, this.arrayOffset, byArray, n, n2);
            this.arrayOffset += n2;
            return n2;
        }

        public synchronized int available() throws IOException {
            return this.arrayLength - this.arrayOffset + super.available();
        }

        public synchronized byte[] readLine() throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            boolean bl = false;
            while (!bl) {
                int n = this.in.read();
                if (n == -1) {
                    bl = true;
                    continue;
                }
                if (n == 8) {
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    byteArrayOutputStream.reset();
                    int n2 = byArray.length - 1;
                    if (n2 <= 0) continue;
                    byteArrayOutputStream.write(byArray, 0, n2);
                    continue;
                }
                if (n == 21) {
                    byteArrayOutputStream.reset();
                    continue;
                }
                if (n == 10) {
                    byteArrayOutputStream.write(n);
                    bl = true;
                    continue;
                }
                byteArrayOutputStream.write(n);
            }
            return byteArrayOutputStream.toByteArray();
        }
    }

    public class TextAreaOutputStream
    extends OutputStream {
        TextArea theTextArea;
        String buffer = "";

        public TextAreaOutputStream(TextArea textArea) {
            AwtConsole.this = AwtConsole.this;
            this.theTextArea = textArea;
        }

        public synchronized void flush() {
            this.theTextArea.append(this.buffer);
            String string = this.theTextArea.getText();
            this.theTextArea.setCaretPosition(string.length());
            this.buffer = "";
        }

        public synchronized void write(int n) {
            if (n < 0) {
                n += 256;
            }
            this.buffer = String.valueOf(this.buffer) + (char)n;
        }
    }

    public class TextAreaInputStream
    extends PipedInputStream
    implements KeyListener {
        TextArea theTextArea;
        OutputStream out;
        int nbrOfKeyTyped;

        public TextAreaInputStream(TextArea textArea) {
            AwtConsole.this = AwtConsole.this;
            try {
                this.theTextArea = textArea;
                this.theTextArea.addKeyListener(this);
                this.out = new PipedOutputStream(this);
                this.nbrOfKeyTyped = 0;
                return;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }

        private void send(char c) {
            try {
                if (c == '\n') {
                    if (AwtConsole.needsAppend()) {
                        this.theTextArea.append(eol);
                    }
                    byte[] byArray = eol.getBytes();
                    this.out.write(byArray, 0, byArray.length);
                    this.out.flush();
                    this.nbrOfKeyTyped = 0;
                    return;
                }
                if (c >= ' ' && c < '\u0100') {
                    if (AwtConsole.needsAppend()) {
                        this.theTextArea.append(String.valueOf(c));
                    }
                    this.out.write(c);
                    ++this.nbrOfKeyTyped;
                    return;
                }
                if (c != '\r') {
                    this.theTextArea.append("?");
                    this.out.write(63);
                    ++this.nbrOfKeyTyped;
                    return;
                }
            }
            catch (IOException iOException) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private void send(String string) {
            int n = 0;
            while (n < string.length()) {
                this.send(string.charAt(n));
                ++n;
            }
        }

        public synchronized void keyTyped(KeyEvent keyEvent) {
            boolean bl = true;
            try {
                try {
                    char c = keyEvent.getKeyChar();
                    if (c == '\b') {
                        if (this.nbrOfKeyTyped > 0) {
                            this.theTextArea.append("");
                            this.out.write(c);
                            --this.nbrOfKeyTyped;
                            bl = false;
                        }
                    } else if (c == '\r' || c == '\n') {
                        this.send('\n');
                    } else if (c == '\u0015') {
                        if (this.nbrOfKeyTyped > 0) {
                            String string = this.theTextArea.getText();
                            this.theTextArea.setText(string.substring(0, string.length() - this.nbrOfKeyTyped));
                            this.theTextArea.append("");
                            this.out.write(21);
                        }
                    } else if (c >= ' ' && c < '\u00e1') {
                        this.send(c);
                    } else if (c == '\u0003') {
                        bl = false;
                    } else if (c == '\u001a') {
                        itrp.exit();
                    } else if (c == '\u0016') {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        Transferable transferable = clipboard.getContents(this);
                        String string = "";
                        try {
                            string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            this.send(string);
                        }
                        catch (UnsupportedFlavorException unsupportedFlavorException) {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                Object var4_9 = null;
                if (bl) {
                    keyEvent.consume();
                }
                return;
            }
            catch (Throwable throwable) {
                block23: {
                    Object var4_10 = null;
                    if (!bl) break block23;
                    keyEvent.consume();
                }
                throw throwable;
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }
}

