/*
 * Decompiled with CFR 0.152.
 */
package FESI.swinggui;

import FESI.swinggui.HtmlPane;
import FESI.swinggui.PageLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpWindow
extends JFrame
implements HyperlinkListener {
    private HtmlPane html;
    private String helpLocation;
    private Vector history = new Vector();
    private URL contentPageURL;

    HelpWindow(String string) {
        this.helpLocation = string;
        this.setTitle("FESI Help");
        ((Component)this).setSize(600, 500);
        ((Component)this).setBackground(Color.gray);
        this.getContentPane().setLayout(new BorderLayout());
        int n = Toolkit.getDefaultToolkit().getScreenSize().width;
        int n2 = Toolkit.getDefaultToolkit().getScreenSize().height;
        int n3 = this.getSize().width;
        int n4 = this.getSize().height;
        ((Component)this).setLocation((n - n3) / 2, (n2 - n4) / 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        try {
            this.contentPageURL = new URL(string);
            this.html = new HtmlPane(this, this.contentPageURL);
            this.html.setEditable(false);
            this.addHistory(this.contentPageURL);
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add((Component)this.html, "Center");
            jPanel.add((Component)jScrollPane, "Center");
            this.html.addHyperlinkListener(this);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("[[Error opening HELP url '" + string + "': " + malformedURLException + "]]");
        }
        catch (IOException iOException) {
            System.err.println("[[Error accessing HELP url '" + string + "': " + iOException + "]]");
        }
        this.setDefaultCloseOperation(1);
        ((Component)this).setVisible(true);
    }

    public void addHistory(URL uRL) {
        this.history.addElement(uRL);
    }

    public void gotoContentPage() {
        if (this.contentPageURL != null) {
            Cursor cursor = this.html.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.html.setCursor(cursor2);
            SwingUtilities.invokeLater(new PageLoader(null, this.html, this.contentPageURL, cursor));
        }
    }

    public void backHistory() {
        int n = this.history.size() - 2;
        if (n >= 0) {
            URL uRL = (URL)this.history.elementAt(n);
            this.history.removeElementAt(n);
            Cursor cursor = this.html.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.html.setCursor(cursor2);
            SwingUtilities.invokeLater(new PageLoader(null, this.html, uRL, cursor));
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Cursor cursor = this.html.getCursor();
            Cursor cursor2 = Cursor.getPredefinedCursor(3);
            this.html.setCursor(cursor2);
            SwingUtilities.invokeLater(new PageLoader(this, this.html, hyperlinkEvent.getURL(), cursor));
        }
    }
}

