//----------------------------------------------------------------------------
//
// Module:      JPanelDocumentHandler.java      
//
// Description: Handles JPanel elements
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

package FesiForm;

import org.xml.sax.*;
import FESI.jslib.*;

import javax.swing.*;
import java.awt.*;
import java.util.Vector;


public class JPanelDocumentHandler extends DefaultDocumentHandler 
                                   implements DocumentHandler {

    DocumentHandler previousDocumentHandler;
    String script = null;
    JPanel panel = null;
    String containerName;
    Container container;
    String constraint = null;
    
    public JPanelDocumentHandler(String cn,
                                    DocumentHandler pdh, 
                                    Container ct,
                                    GuiContext guiContext, 
                                    boolean trace) {
        super(guiContext, trace);
        this.containerName = cn;
        this.container = ct;
        this.previousDocumentHandler = pdh;
        // Validate assumption
        if (!cn.equals("JPanel")) throw new IllegalArgumentException("** Unexpected container name for JPanel: " + cn);
    }
  
      
    // Receive notification of the beginning of an element.
    public void startElement(String name, AttributeList atts) throws SAXException {
        if (trace) System.out.println("JPanel START_ELEMENT: <" + name + ">, " + 
                                         atts.getLength() + " attribute(s)");
        if (name.equals("JPanel")) {
            processOptionalId(panel, atts);
            panel = new JPanel();
            panel = (JPanel) createComponent(JPanel.class, atts);
            processComponentAttributes(panel, atts);
            processLAYOUT(panel, atts);
            constraint = getAttribute("constraint", atts);
            script = saveScript(panel, atts);
            DocumentHandler dh = 
                new ContentDocumentHandler("JPanel", this, null, panel, guiContext, trace, -1);
            guiContext.parser.setDocumentHandler(dh);
            dh.startElement(name, atts);
        } else {
            throw new SAXException("Unexpected ELEMENT in panel ignored: " + name);
        }
    }

    // Receive notification of the end of an element. 
    public void endElement(String name) throws SAXException {
        if (trace) System.out.println("JPanel END_ELEMENT: </" + name + ">");
        if (name.equals("JPanel")) {  
            addConstrained(container, panel, constraint);
            processScript(panel, script);
            previousDocumentHandler.endElement(name);
        } else {
            throw new SAXException("Unexpected ELEMENT end in panel ignored: " + name);
        }
    }
    
 }