@echo off
rem setup.bat - FESI - JM Lugrin
rem 
rem Start the setup program to install the FESI command files.
rem The setup program is itself written in EcmaScript and is
rem called setup.es. It can be found in the .../fesi/bin directory.
rem
rem This file must be started in the .../fesi/bin directory.
rem
rem If the variable JAVACMD is not defined below, then 
rem the script will attempt to find which java command to 
rem use by itself. This should work in most of the cases.
rem Note that the JDK1.1 java commands does not recognize
rem the option -cp and therefore requires that a full
rem classpath environment variable be defined.
rem
rem Java command to use
set JAVACMD=
rem Command parameters (set at least classpath to ../fesi.jar!)
rem For jre like commands: JAVAOPT=-cp ../fesi.jar
rem For java like commands: JAVAOPT=-classpath ../fesi.jar;%CLASSPATH%
set JAVAOPT=
rem
rem SETUPCMD can be used to call a setup script both for
rem this script and for the generated scripts. For example
rem to set proper path and classpath for a specific version
rem of Java. For example: set SETUPCMD=CALL E:\java\fesi\bin\SET12.BAT
set SETUPCMD=
rem
rem Do the setup command in the script creation environment
if not "%SETUPCMD%"=="" %SETUPCMD%
rem
rem Check that we are in the right directory
if not exist setup.bat goto baddir
if not exist setup.es goto baddir
if not exist ..\fesi.jar goto badjar

rem Check the command - hacky on windows
if "%JAVACMD%"=="" goto getcmd
if "%JAVAOPT%"=="" goto noopt
goto cmdoptok

:getcmd
echo IGNORE THE HELP MESSAGE OR ERRORS BELOW
jre -anerroneousoption
if errorlevel 1 goto isjre
java -anerroneousoption
if errorlevel 1 goto isjava

echo ** ERROR **
echo No command found, please setup JAVACMD in SETUP.BAT
exit 1

:isjre
set JAVACMD=jre
set JAVAOPT=-cp ..\fesi.jar
goto cmdfound
:isjava
set JAVACMD=java
rem Check if java 1.1 or 1.2
java -X
if errorlevel 1 goto is11
rem java 1.2, recognize the option CP
set JAVAOPT=-cp ..\fesi.jar
goto cmdfound
rem java 1.1, does not recognize the option -cp
rem therefore CLASSPATH must be defined
:is11
if "%CLASSPATH%"=="" goto nocp
set JAVAOPT=-classpath ..\fesi.jar;%CLASSPATH%

:cmdfound
echo IGNORE THE HELP MESSAGE OR ERRORS ABOVE
echo ""

:cmdoptok
echo Command found: %JAVACMD% %JAVAOPT%

rem Start the FESI interpreter for setup.es 
echo Starting the configuration script
%JAVACMD% %JAVAOPT%  -DOS=W -DCMD="%JAVACMD%" -DSC="%SETUPCMD%" -DSWING_HOME=%SWING_HOME% FESI.Interpreter.Interpret -w -f setup.es

echo TERMINATED
goto end

rem Error message - bad directory
:baddir
echo The file setup.bat must be started in the .../fesi/bin directory,
echo which must contain the file setup.es
exit 1

rem Error message - bad fesi.jar
:badjar
echo The directory above the current one must contain fesi.jar
exit 1

rem Error message - JAVAOPT missing
:noopt
echo JAVAOPT must be specified if JAVACMD is specified, see SETUP.BAT
exit 1

rem Error message - no CLASSPATH for java 1.1
:nocp
echo CLASSPATH must be specified for java 1.1 (non jre), see SETUP.BAT
exit 1

:end
exit
 