// setup.es
// JM Lugrin - January 2000
//
// Setup the FESI environment, creating the needed batch files.
//
// Implemented in 3 phases
// 1. Get the information from the environment
// 2. Ask confirmation and additional information from the user
// 3. Create the batch files
//
// ---------------------------------------------------------------
//
// Configuration (for testing)
var inDev=false;  // True if in interactive development, false if in production
var inDevOS = "W";   // Simulate OS parameter in development mode
var inDevCMD = "jre";   // Simulate CMD parameter in development mode
var inDevSH = "C:\\java\\swing-1.1"; // Simulate the SWING_HOME parameter in development mode

var setupFileName = 'setup.es'; // Name of this file

// Exit if in production mode
function doExit(n) {
   if (inDev) {
    alert("In Development\nShould exit (" + n + ")");
   } else {
    exit(n); // Comment for development
   }
}

// Get information on the current environment
var properties = java.lang.System.getProperties();

var userDir = properties.get('user.dir'); // Should be where we launched setup!
var osName = properties.get('os.name').toLowerCase(); 
var javaVersion = properties.get('java.version'); // For 1.1 or 1.2
var pathSeparator = properties.get('path.separator');
var fileSeparator = properties.get('file.separator');
var shParam = properties.get('SWING_HOME'); // null if not present
var osParam = properties.get('OS'); // null if not present
var cmdParam = properties.get('CMD'); // null if not present
var scParam = properties.get('SC'); // null if not present

// Simulate parameters if in development mode
if (inDev && osParam==null) {osParam = inDevOS;}
if (inDev && cmdParam==null) {cmdParam = inDevCMD;}
if (inDev && shParam==null) {shParam = inDevSH;}

// Normalize to null if optional parameter SWING_HOME is blank
if (shParam=="") {shParam = null;}

// Check that mandatory parameters are present and valid
// (that is that we are called by the proper script)
if (osParam==null || cmdParam == null) {
   alert("Script not called by the setup.bat\nor setup shell script");
   doExit(1);
}
if (osParam!='W' && osParam != 'U') {
    alert("Illegal OS parameter\ncheck the BAT or shell script");
    doExit(1);
}

// Get the operating system type from the command file
var osFullName = (osParam=='W') ? 'Microsoft Window' : 'Unix';
osFullName += " (" + osName + ")"; // for documentation purpose only

// Check if the directory is the one containing the bin file
// (should be checked by the calling script too)
var setupFile = new File(userDir,setupFileName);
if (!setupFile.exists()) {
   alert("File " + setupFileName + " not found in default directory\n" + 
          userDir + "\n" +
         "Make sure you start setup from its directory (.../fesi/bin)");
   doExit(1);
}

// Check that the files are in the expected place
var fesiDir = (new File(userDir)).getParent();
var fesiJar = new File(fesiDir,"fesi.jar");
if (!fesiJar.exists()) {
   alert("fesi.jar not found in\n" + 
          fesiDir + "\n" +
         "Please restore it");
   doExit(1);
}

// Find the version of the jdk
// We are interested only in 1.1 or 1.2 (1.0 is not supported)
// The main difference is the commands - 1.1 uses jre and jrew
// and does not support -cp on the java command
var defaultVersion = 12; 
if (javaVersion.indexOf('1.0')==0) {
   // We should not even arrive here !
   alert("Version pre 1.1 ( "+ javaVersion + ") not supported");
} else if (javaVersion.indexOf('1.1')==0) {
   defaultVersion = 11;
} // if not 1.1. assume 1.2 or compatible


// Check if we have Swing
// Swing may be present in the default class path (in 1.2) or
// in a library pointed to by SWING_HOME (in 1.1).
// First check if it is in the default classpath
var hasSwing = (typeof Packages.javax.swing.JOptionPane) != 'JavaPackage';
if (shParam != null) {
    // If we had a SWING_HOME parameter, some tuning is needed
    if (hasSwing) {
        // If we have swing in the default classpath, do not
        // bother for a SWING_HOME environment
        shParam = null;
    } else {
        // Maybe we have SWING after all
        if (File(shParam,'swingall.jar').exists()) {
            hasSwing = true;
        }
    }
}



// Validate all parameters, ask user to confirm
validateParameters();
    
// Build the command
var isJre = cmdParam.toLowerCase().indexOf("jre")>=0;
var cpOption="";
var cmd = ""; // for basic fesi
var cmdw = ""; // for fesi with awt
var cmds = ""; // for fesi with Swing
var cmdev = ""; // for fesi development
if (isJre || defaultVersion==12) {
    // JRE or java 1.2: use -cp and no class path
    cpOption = '-cp "' + fesiJar.getAbsolutePath() +'"';
    cmd = cmdParam + " " + cpOption +
        " FESI.Interpreter.Interpret -f %1";
    cmdw = cmdParam + "w " + cpOption + 
        " FESI.Interpreter.Interpret -w -f %1";
    if (hasSwing) {
        var docFile = new File(fesiDir,"doc");
        docFile = new File(docFile,"html");
        docFile = new File(docFile,"index.html");
        
        cmds = cmdParam + "w " + cpOption;
        if (shParam!=null) {
            var swingJar = new File(shParam,"swingall.jar");
            cmds+=pathSeparator + swingJar;
        }
        cmds += " FESI.Interpreter.Interpret -s -f %1";
        cmddev = cmdParam + "w " + "-DFESI.path=. " +
                ' "-DFESI.help=file:' + docFile.getAbsolutePath() + '"' +
                " " + cpOption;
        if (shParam!=null) {
            var swingJar = new File(shParam,"swingall.jar");
            cmddev+=pathSeparator + swingJar;
        }
        cmddev += " FESI.Interpreter.Interpret -s -i %1 %2 %3 %4";
    } else {
        cmddev = cmdParam + "w " + cpOption + 
            " FESI.Interpreter.Interpret -w -i -f %1";
    }
} else {
    // java 1.1: use -classpath and current class path
    cpOption = '-classpath "';
    // Make sure that all file references are absolutes
    var cpArray = properties.get('java.class.path').split(pathSeparator);
    for (var ix in cpArray) {
        var cpFile = new File(cpArray[ix]);
        if (ix!=0) {cpOption += pathSeparator;}
        cpOption += cpFile.getAbsolutePath();
    }
	cpOption += "'";
    cmd = cmdParam + " " + cpOption +
        " FESI.Interpreter.Interpret -f %1";
    cmdw = cmdParam + " " + cpOption + 
        " FESI.Interpreter.Interpret -w -f %1";
    if (hasSwing) {
        var docFile = new File(fesiDir,"doc");
        docFile = new File(docFile,"html");
        docFile = new File(docFile,"index.html");
        cmds = cmdParam + " " + cpOption;
        if (shParam!=null) {
            var swingJar = new File(shParam,"swingall.jar");
            cmds+=pathSeparator + swingJar;
        }
        cmds += " FESI.Interpreter.Interpret -s -f %1";
        cmddev = cmdParam + " " + "-DFESI.path=. " +
                " -DFESI.help=file:" + docFile.getAbsolutePath() +
                " " + cpOption;
        if (shParam!=null) {
            var swingJar = new File(shParam,"swingall.jar");
            cmddev += pathSeparator + swingJar;
        }
        cmddev += " FESI.Interpreter.Interpret -s -i %1 %2 %3 %4";
    } else {
        cmddev = cmdParam + " " + cpOption + 
            " FESI.Interpreter.Interpret -w -i %1 %2 %3";
    }
}
var a = confirm("Write commands to " + userDir);
if (a) {
    var createdFiles = "";
    makeFile("fesidev.bat",cmddev,"Used to start the FESI development environment");
    makeFile("fesi.bat",cmd,"Used to start a fesi scripts without window");
    makeFile("fesiw.bat",cmdw,"Used to start a fesi scripts with AWT window");
    if (cmds!="") {
        makeFile("fesis.bat",cmds,"Used to start a fesi scripts with Swing window");
    }
    alert("Done\n" + createdFiles);
} else {
    alert("No file created");
}

doExit(0);





// --------------------------------------------------------------------------

function makeFile(name, command, comment) {
    var f = new File(userDir,name);
    f.remove();
    f.open();
    f.writeln("rem " + name + " created on " + new Date());
    f.writeln("rem FESI file for " + osFullName);
    var version = defaultVersion==11 ? 'Java 1.1' : 'Java 2 (1.2) or later';
    f.writeln("rem For " + version);
    f.writeln("rem " + comment);
    if (scParam!=null && scParam != "") {
        f.writeln(scParam);
    }
    f.writeln(command);
    f.close();
    createdFiles += name + " " + comment + "\n";
}


function validateParameters() {
    validateVersion();
    validateDirectory();
    validateSwing();
}


        
// Validate that the version is the expected one
function validateVersion() {
    var a = false;
    while (!a) {
        var version = defaultVersion==11 ? 'Java 1.1' : 'Java 2 (1.2) or later';
        a = confirm('Java version (' + javaVersion + ')\nis ' + version + '?');
    if (!a) {
       var toldVersion = prompt("Java version ('1.1','1.2 (or later)')?",'1.2').toLowerCase();
       if (toldVersion.indexOf('1.1')==0) {
          defaultVersion=11;
       } else {
          defaultVersion = 12;
       }
    }
   } // while
}  

// Validate that the target directory is the expected one
function validateDirectory() {
    var a = false;
    var originalUserDir = userDir;
    while (!a) {
        a = confirm('Command files will be created\nin directory ' + userDir);
    if (a) {
       if (!File(userDir).isDirectory()) {
          alert('Not a directory:\n' + userDir);
          a =  false;
       }
    }
    if (!a) {
        userDir = prompt("Target directory ? ", originalUserDir);
    }
    } // while
}

// Validate that swing is present or not
function validateSwing() {
    var a = false;
    while (!a) {
        var hasSwingString = hasSwing ? "Swing is present" : "No Swing present";
        if (hasSwing) {
            if (shParam==null) {
                hasSwingString += "\nin default classpath"; 
            } else {
                hasSwingString += "\nin directory " + shParam; 
            }
        }
        a = confirm(hasSwingString);
        if (a && shParam!=null) {
           if (!File(shParam,"swingall.jar").exists()) {
              alert('Directory ' + shParam + "\ndoes not contain fesiall.jar");
              a =  false;
           }
        }
        if (!a) {
            var swingDir = prompt("Swing directory (empty for none)", 
                shParam==null ? '' : shParam);
                if (swingDir=='') {
                    hasSwing = false;
                } else {
                    hasSwing = true;
                    shParam =swingDir;
                }
        }
    } // while
}

