//----------------------------------------------------------------------------
//
// Module:      ConnectDialog.java      
//
// Description: Connection dialog box for FesiFTP
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

class ConnectDialog extends Dialog {
    
    String server = null;
    String username = null;
    String password = null;
    TextField tfServer = null;
    TextField tfUsername = null;
    TextField tfPassword = null;
    

    /**
     * Create a connection parameter request dialog
     *
     * @param   parent  The parent frame
     * @param   center  The center of the new dialog
     * @param   defaultServer  Default value for server
     * @param   defaultUsername  Default value for username
     * @param   defaultPassword  Default value for password
     */
    ConnectDialog (Frame parent, Point center,
                String defaultServer,
                String defaultUsername,
                String defaultPassword) {
        super(parent, "Connect parameters", true);
        Label lblTmp;
        GridBagConstraints gbc;
        
        if (defaultServer == null) defaultServer = "";
        if (defaultUsername == null) defaultUsername = "";
        if (defaultPassword == null) defaultPassword = "";
        
        // Specify a LayoutManager for it
        this.setLayout(new BorderLayout(10, 10));
        
        // Entry fiels
        Panel pnlEntry = new Panel ();
        GridBagLayout gbTemp  = new GridBagLayout ();
        pnlEntry.setLayout (gbTemp);

        lblTmp = new Label("Host: ", Label.RIGHT);
        gbc        = new GridBagConstraints ();
        gbc.anchor = GridBagConstraints.EAST;
        gbc.insets = new Insets (5, 3, 0, 0);
        gbTemp.setConstraints (lblTmp, gbc);
        pnlEntry.add(lblTmp);

        tfServer = new TextField(defaultServer,40);
        gbc           = new GridBagConstraints ();
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.insets    = new Insets (5, 0, 0, 3);
        gbTemp.setConstraints (tfServer, gbc);
        pnlEntry.add(tfServer);

        
        lblTmp = new Label("Username: ", Label.RIGHT);
        gbc        = new GridBagConstraints ();
        gbc.anchor = GridBagConstraints.EAST;
        gbc.insets = new Insets (5, 3, 0, 0);
        gbTemp.setConstraints (lblTmp, gbc);
        pnlEntry.add(lblTmp);

        tfUsername = new TextField(defaultUsername,40);
        gbc           = new GridBagConstraints ();
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.insets    = new Insets (5, 0, 0, 3);
        gbTemp.setConstraints (tfUsername, gbc);
        pnlEntry.add(tfUsername);

        
        lblTmp = new Label("Password: ", Label.RIGHT);
        gbc        = new GridBagConstraints ();
        gbc.anchor = GridBagConstraints.EAST;
        gbc.insets = new Insets (5, 3, 0, 0);
        gbTemp.setConstraints (lblTmp, gbc);
        pnlEntry.add(lblTmp);

        tfPassword = new TextField(defaultPassword,40);
        tfPassword.setEchoChar('*');
        gbc           = new GridBagConstraints ();
        gbc.gridwidth = GridBagConstraints.REMAINDER;
        gbc.insets    = new Insets (5, 0, 0, 3);
        gbTemp.setConstraints (tfPassword, gbc);
        pnlEntry.add(tfPassword);
      
        
        this.add("Center", pnlEntry);


        Panel pnlButtons = new Panel ();
        pnlButtons.setLayout (new FlowLayout());
        
        Button bCancel = new Button("Cancel");
        bCancel.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                server = null;      // To mark cancelled rather than default
                username = null;
                password = null;
                ConnectDialog.this.dispose();
            }
        });
        pnlButtons.add(bCancel);

        Button bOk = new Button("   OK   "); // Poor man's centering
        bOk.addActionListener( new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                server = tfServer.getText();
                username = tfUsername.getText();
                password = tfPassword.getText();
                ConnectDialog.this.dispose();
            }
        });
        pnlButtons.add(bOk);
        
        this.add("South", pnlButtons);

        this.pack();
        setLocation (center.x - (getSize ().width / 2), center.y - (getSize ().height / 2));

        tfServer.requestFocus ();
    }
}