//----------------------------------------------------------------------------
//
// Module:      MessageBox.java      
//
// Description: Message box dialog for FesiFTP
//
// FESI Copyright (c) Jean-Marc Lugrin, 2000
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.

// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//----------------------------------------------------------------------------

import java.awt.*;
import java.awt.event.*;

/**
 * Create a multi-line message box to display a message that
 * the user must acknowledge (typically an error message).
 */
public class MessageBox extends Dialog {
    
    public MessageBox(Frame parent, Point center, String title, String message) {
      super(parent, title, true);
      setLayout(new BorderLayout(10,10));
      setBackground(Color.lightGray);
      //TextArea textArea = new TextArea(message);
      //textArea.setEditable(false);
      MultiLineLabel mll = new MultiLineLabel(message,15,15);
      add("Center", mll);
      Panel panel = new Panel();
      panel.setLayout(new FlowLayout(FlowLayout.CENTER,10,10));
      add("South", panel);
      Button bOK = new Button("  OK  ");
      panel.add(bOK);
      
      pack();
       setLocation (center.x - (getSize ().width / 2), center.y - (getSize ().height / 2));
      
      addWindowListener(new WindowAdapter() {
          public void windowClosing(WindowEvent e) {
              dispose();
          }
      });
      bOK.addActionListener(new ActionListener() {
          public void actionPerformed(ActionEvent e) {
              dispose();
          }
      });
   }
          
}