// FGA example: bit counter (multi-threaded version)
// by Alessandro Presta
// This source code is protected by the GNU Lesser General Public License
// (see license.txt)

#include "fga.hpp"
#include <cstdlib>
#include <ctime>
#include <iostream>

using namespace fga;
using namespace std;

#define T 2 // number of tribes (threads) in population
#define N 4000 // number of chromosomes in population
#define L 20 // number of genes in a chromosome
#define G 10000 // number of generations

// fitness evaluation function
float my_fitness(bool *chromosome)
{
	float sum = 0;
	for (int i = 0; i < L; ++i)
		if (chromosome[i] == 1)
			++sum;
	return sum;	
}

// gene mutation function
bool my_mutate_gene(bool gene)
{
	if (gene == 1)
		return 0;
	else
		return 1;	
}

// random gene creation function
bool my_random_gene()
{
  return rand() % 2;	
}

int main()
{
	srand(time(NULL));
	PopulationMT<bool> my_population(T, N / T, L, my_fitness, my_mutate_gene, my_random_gene, NULL, NULL, NULL);
	my_population.run(L, G); // try to achieve 100% fitness
	if (my_population.get_best_score() >= L) {
	cout << "Problem solved in " << my_population.get_generations() << " generations" << endl;
	cout << "chromosome: ";
	for (int i = 0; i < L; ++i)
		cout << my_population.get_best()[i];
		cout << endl;
	}
	else
		cout << "Problem not optimally solved" << endl;
	return 0;
}
