// FGA example: travelling salesman problem (brute-force version)
// by Alessandro Presta
// This source code is protected by the GNU Lesser General Public License
// (see license.txt)

#include <cstdlib>
#include <cstring>
#include <ctime>
#include <math.h>
#include <algorithm>
#include <fstream>
#include <iostream>

using namespace std;

#define MAX_COST 10 // maximum cost for a road
#define PRINT_ALL() {	system("clear"); \
						cout << "Brute force algorithm" << endl << endl; \
						if (L <= 20) \
							cout << "Progress:                " << (int)pct << "% (" << count << " of " << L_fact << " paths generated)" << endl << endl; \
						else \
							cout << "Progress:                " << count << " paths generated" << endl << endl; \
						cout << "Best cost:               " << best_cost << endl << endl; \
						cout << "Best path:" << endl; \
						for (int i = 0; i < L; ++i) \
							cout << best_path[i] << " "; \
						cout << endl << endl; \
		    		}

int L; // number of nodes in the graph
int **cost; // cost for the road between nodes [i][j]
int *best_path;
int best_cost;

long fact(int n)
{
	if (n == 0)
		return 1;
	return n * fact(n - 1);	
}

int main()
{
	srand(time(NULL));
	ifstream in_file("graph.txt");
	in_file >> L;
	cost = new int*[L];
	for (int i = 0; i < L; ++i) {
		cost[i] = new int[L];
		for (int j = 0; j < L; ++j)
			cost[i][j] = 0;
	}
	best_path = new int[L];
	for (int i = 0; i < L - 1; ++i)
		for (int j = i + 1; j < L; ++j) {
			in_file >> cost[i][j];
			cost[j][i] = cost[i][j];
		}
	in_file.close();
	best_cost = MAX_COST * L;
	int path[L];
	for (int i = 0; i < L; ++i)
		path[i] = i;
	int count = 0;
	long L_fact = fact(L);
	float pct;
	do {
		int total_cost = 0;
		for (int i = 0; i < L - 1; ++i)
			total_cost += cost[path[i]][path[i + 1]];
		if (total_cost < best_cost) {
			best_cost = total_cost;
			memcpy(best_path, path, L * sizeof(int));
			PRINT_ALL();
		}
		count++;
		if (count % 10000 == 0)
			PRINT_ALL();
		if (L <= 20) {
			pct = (float)count / L_fact * 100;
			if (pct - (int)pct < 0.5)
				pct = floor(pct);
			else
				pct = ceil(pct);
		}
	} while (next_permutation(path, path + L));
	PRINT_ALL();
	for (int i = 0; i < L; ++i)
		delete[] cost[i];
	delete[] cost;
	delete[] best_path;
	return 0;
}
