/*
**  Copyright 2000-2004 University of Illinois Board of Trustees
**  Copyright 2000-2004 Mark D. Roth
**  All rights reserved.
**
**  output.c - code to print out ftp directory entries
**
**  Mark D. Roth <roth@feep.net>
*/

#include <fget.h>

#include <stdio.h>
#include <errno.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifdef STDC_HEADERS
# include <string.h>
#endif

#ifdef MAJOR_IN_MKDEV
# include <sys/mkdev.h>
#else
# ifdef MAJOR_IN_SYSMACROS
#  include <sys/sysmacros.h>
# endif
#endif


static const char *months[] = {
	"Jan", "Feb", "Mar", "Apr", "May", "Jun",
	"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
};


void
ftp_long_ls(FTP *ftp, char *filename, struct ftpstat *fsp)
{
	char modestring[12];
	struct tm *mtm;
	char buf[MAXPATHLEN];

	strmode(fsp->fs_mode, modestring);
	printf("%.10s %3hu %-8.8s %-8.8s ",
	       modestring, (unsigned short)fsp->fs_nlink, fsp->fs_username,
	       fsp->fs_groupname);

	if (S_ISCHR(fsp->fs_mode) || S_ISBLK(fsp->fs_mode))
		printf(" %3ld, %3ld ",
		       (long)major(fsp->fs_rdev), (long)minor(fsp->fs_rdev));
	else
		printf("%9lu ", (unsigned long)fsp->fs_size);

	mtm = localtime(&(fsp->fs_mtime));
	printf("%.3s %2d %2d:%02d %4d %s",
	       months[mtm->tm_mon],
	       mtm->tm_mday,
	       mtm->tm_hour,
	       mtm->tm_min,
	       mtm->tm_year + 1900,
	       basename(filename));

	if (S_ISLNK(fsp->fs_mode))
	{
		ftp_readlink(ftp, filename, buf, sizeof(buf));
		printf(" -> %s", buf);
	}

	putchar('\n');
}


void
send_debug(char *text, FTP *ftp, void *dummy)
{
	printf(">>> %s\n", text);
}


void
recv_debug(char *text, FTP *ftp, void *dummy)
{
	printf("<<< %s\n", text);
}


