/*
**  Copyright 2000-2004 University of Illinois Board of Trustees
**  Copyright 2000-2004 Mark D. Roth
**  All rights reserved.
**
**  ftpsite.c - FTP SITE command handling
**
**  Mark D. Roth <roth@feep.net>
*/

#include <internal.h>

#include <errno.h>

#ifdef STDC_HEADERS
# include <string.h>
#endif


/* execute a site command */
int
ftp_site(FTP *ftp, char *fmt, ...)
{
	va_list args;
	int retval, code;
	char buf[FTPBUFSIZE];

	snprintf(buf, sizeof(buf), "SITE %s", fmt);

	va_start(args, fmt);
	retval = _vftp_send_command(ftp, buf, args);
	va_end(args);
	if (retval == -1)
		return -1;

	if (_ftp_get_response(ftp, &code, buf, sizeof(buf)) == -1)
		return -1;
	if (code != 200)
	{
		if (code == 421)
			errno = ECONNRESET;
		else
			errno = EINVAL;
		return -1;
	}

	return 0;
}


/* execute a site command */
int
ftp_site_open(FTPFILE **ftpfile, FTP *ftp, int mode, char *fmt, ...)
{
	va_list args;
	int retval;
	char buf[FTPBUFSIZE];

	if (mode != O_RDONLY
            && mode != O_WRONLY)
	{
		errno = ENOSYS;
		return -1;
	}

	snprintf(buf, sizeof(buf), "SITE %s", fmt);

	va_start(args, fmt);
	retval = _vftp_open_aux(ftpfile, ftp, mode, buf, args);
	va_end(args);

	return retval;
}


