/*
**  Copyright 2000-2004 University of Illinois Board of Trustees
**  Copyright 2000-2004 Mark D. Roth
**  All rights reserved.
**
**  list_parse_nt.c - NT-style FTP directory parsing code
**
**  Mark D. Roth <roth@feep.net>
*/

#include <internal.h>

#include <stdio.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifdef STDC_HEADERS
# include <string.h>
# include <stdlib.h>
#endif

/* needed for strcasecmp() on some platforms */
#include <strings.h>


/* parse Windows NT directories */
int
_ftp_list_parse_nt(FTP *ftp, char *buf, file_info_t *fip)
{
	char *linep = buf, *fieldp;
	char am_pm[3];
	struct tm tt;
	unsigned long ul;

#ifdef DEBUG
	printf("==> _ftp_list_parse_nt(ftp=0x%lx (%s), buf=0x%lx, fip=0x%lx)\n",
	       ftp, ftp->ftp_host, buf, fip);
#endif

	/* give bogus info for unlisted fields */
	fip->fi_stat.fs_mode = S_IRWXU | S_IRWXG | S_IRWXO;
	strlcpy(fip->fi_stat.fs_username, "-1",
		sizeof(fip->fi_stat.fs_username));
	strlcpy(fip->fi_stat.fs_groupname, "-1",
		sizeof(fip->fi_stat.fs_groupname));
	fip->fi_stat.fs_nlink = 1;

	memset(&tt, 0, sizeof(tt));

	/* parse date field */
	do
		fieldp = strsep(&linep, " \n");
	while (fieldp != NULL && *fieldp == '\0');
	sscanf(fieldp, "%2d-%2d-%2d", &tt.tm_mon, &tt.tm_mday, &tt.tm_year);
	tt.tm_mon--;
	if (tt.tm_year < 50)
		tt.tm_year += 100;

	/* parse time of day */
	do
		fieldp = strsep(&linep, " \n");
	while (fieldp != NULL && *fieldp == '\0');
	sscanf(fieldp, "%2d:%2d%2s", &tt.tm_hour, &tt.tm_min, am_pm);
	if (strcasecmp(am_pm, "PM") == 0)
		tt.tm_hour += 12;
	else if (tt.tm_hour == 12)
		tt.tm_hour = 0;

	/* save full time stamp */
	fip->fi_stat.fs_mtime = mktime(&tt);

	/* parse size or directory */
	do
		fieldp = strsep(&linep, " \n");
	while (fieldp != NULL && *fieldp == '\0');
	if (strcmp(fieldp, "<DIR>") == 0)
		fip->fi_stat.fs_mode |= S_IFDIR;
	else
	{
		fip->fi_stat.fs_mode |= S_IFREG;
		sscanf(fieldp, "%lu", &ul);
		fip->fi_stat.fs_size = (off_t)ul;
	}

	/* last but not least, file name */
	fieldp = linep + strspn(linep, " ");
	strlcpy(fip->fi_filename, fieldp, sizeof(fip->fi_filename));

#ifdef DEBUG
	printf("<== _ftp_list_parse_nt()\n");
#endif
	return FLP_VALID;
}


