#include <sys/param.h>
#include <sys/stat.h>
#include <string.h>

#include <test_open.c>

void
test_read(char *url)
{
	char path[MAXPATHLEN];
	char buf[11];
	FTPFILE *ftpfile;

	test_login(url);

	snprintf(path, sizeof(path), "%s/libfget_test/long.txt",
		 ftpurl.fu_path);

	test_open_aux(path, O_RDONLY, &ftpfile, 1);

	if (ftp_read(ftpfile, buf, sizeof(buf) - 1) == -1)
	{
		perror("ftp_read()");
		exit(1);
	}

	buf[sizeof(buf)] = '\0';
	if (strcmp(buf, "0123456789") != 0)
	{
		fprintf(stderr, "file contents do not match expected value\n");
		fprintf(stderr, "read \"%s\", should be \"0123456789\"\n",
			buf);
		exit(2);
	}
}


